/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

class TestStatistics
implements Comparable {
    private String _name;
    private int _totalOriginalBytes;
    private int _totalCodedBytes;
    private int _numTests;
    private double _totalEncodeSpeed;
    private double _totalDecodeSpeed;
    private double _totalCompressionRate;
    private long _totalEncodeTime;
    private long _totalDecodeTime;

    public int compareTo(Object that) {
        return this.compareTo((TestStatistics)that);
    }

    public String toString() {
        StringBuffer report = new StringBuffer();
        report.append("\n");
        report.append("TEST: " + this._name);
        report.append("\n");
        report.append("Overall Compression Rate " + TestStatistics.roundOff(8.0 * TestStatistics.rate(this._totalCodedBytes, this._totalOriginalBytes)) + " b/B");
        report.append("\n");
        report.append("Overall Encode Speed     " + TestStatistics.roundOff(TestStatistics.rate(this._totalOriginalBytes, this._totalEncodeTime)) + " kB/s");
        report.append("\n");
        report.append("Overall Decode Speed     " + TestStatistics.roundOff(TestStatistics.rate(this._totalOriginalBytes, this._totalDecodeTime)) + " kB/s");
        report.append("\n");
        report.append("Average Compression Rate " + TestStatistics.roundOff(8.0 * this._totalCompressionRate / (double)this._numTests));
        report.append("\n");
        report.append("Average Encode Speed     " + TestStatistics.roundOff(this._totalEncodeSpeed / (double)this._numTests));
        report.append("\n");
        report.append("Average Decode Speed     " + TestStatistics.roundOff(this._totalDecodeSpeed / (double)this._numTests));
        return report.toString();
    }

    TestStatistics(String name) {
        this._name = name;
    }

    void record(int originalBytes, int codedBytes, long encodeTime, long decodeTime) {
        ++this._numTests;
        this._totalOriginalBytes += originalBytes;
        this._totalCodedBytes += codedBytes;
        this._totalEncodeTime += encodeTime;
        this._totalDecodeTime += decodeTime;
        this._totalCompressionRate += TestStatistics.rate(codedBytes, originalBytes);
        this._totalEncodeSpeed += TestStatistics.rate(originalBytes, encodeTime);
        this._totalDecodeSpeed += TestStatistics.rate(originalBytes, decodeTime);
    }

    String lineReport() {
        return this._name + TestStatistics.roundOff(8.0 * TestStatistics.rate(this._totalCodedBytes, this._totalOriginalBytes), 8, 2) + TestStatistics.roundOff(TestStatistics.rate(this._totalOriginalBytes, this._totalEncodeTime), 8, 0) + TestStatistics.roundOff(TestStatistics.rate(this._totalOriginalBytes, this._totalDecodeTime), 8, 0) + TestStatistics.roundOff(8.0 * this._totalCompressionRate / (double)this._numTests, 8, 2) + TestStatistics.roundOff(this._totalEncodeSpeed / (double)this._numTests, 8, 0) + TestStatistics.roundOff(this._totalDecodeSpeed / (double)this._numTests, 8, 0);
    }

    private int compareTo(TestStatistics that) {
        if (this._totalCompressionRate < that._totalCompressionRate) {
            return 1;
        }
        if (this._totalCompressionRate > that._totalCompressionRate) {
            return -1;
        }
        return this._name.compareTo(that._name);
    }

    private static double rate(long a, long b) {
        return (double)a / (double)b;
    }

    private static String roundOff(double x) {
        return TestStatistics.roundOff(x, 8, 2);
    }

    private static String roundOff(double x, int width, int numDecimalPlaces) {
        double factor = 1.0;
        for (int i = 0; i < numDecimalPlaces; ++i) {
            factor *= 10.0;
        }
        return TestStatistics.roundOff(x, factor, width);
    }

    private static String roundOff(double x, double factor, int width) {
        int intRep = (int)(factor * x);
        String result = "" + (double)((int)(factor * x)) / factor;
        for (int i = 0; i < 1 && intRep % 10 == 0; ++i) {
            result = result + "0";
            intRep /= 10;
        }
        if (factor == 1.0) {
            result = "" + (int)x;
        }
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }
}

