/*
 * Decompiled with CFR 0.152.
 */
package com.codeberry.jdatapath;

import com.codeberry.jdatapath.DataPath;
import com.codeberry.jdatapath.LocalDataPathSystem;
import com.codeberry.jdatapath.unknown.UnknownSystem;
import com.codeberry.jdatapath.windows.WindowsSystem;

public class JDataPathSystem {
    private static final LocalDataPathSystem SYSTEM;
    private static final String FILE_SEPARATOR;

    public static LocalDataPathSystem getLocalSystem() {
        return SYSTEM;
    }

    public static String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    private static boolean isWindows(String osName) {
        return osName.indexOf("win") >= 0;
    }

    private static boolean isUnix(String osName) {
        return osName.indexOf("nux") >= 0 || osName.indexOf("nix") >= 0;
    }

    private static boolean isMac(String osName) {
        return osName.indexOf("mac") >= 0;
    }

    public static void main(String[] args) {
        String wantedDirName = "<please input wanted dir>";
        if (args.length > 0) {
            wantedDirName = args[0];
        }
        DataPath localDataPath = JDataPathSystem.getLocalSystem().getLocalDataPath(wantedDirName);
        System.out.println("Local data path: " + localDataPath);
        DataPath profilePath = JDataPathSystem.getLocalSystem().getUserProfilePath();
        System.out.println("Profile path: " + profilePath);
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "";
        }
        SYSTEM = JDataPathSystem.isWindows(osName = osName.toLowerCase()) ? new WindowsSystem() : (JDataPathSystem.isUnix(osName) || JDataPathSystem.isMac(osName) ? new UnknownSystem() : new UnknownSystem());
    }
}

