/*
 * Decompiled with CFR 0.152.
 */
package com.codeberry.jdatapath.windows;

import com.codeberry.jdatapath.DataPath;
import com.codeberry.jdatapath.JDataPathSystem;
import com.codeberry.jdatapath.LocalDataPathSystem;
import com.codeberry.jdatapath.windows.CCIDL;

public class WindowsSystem
implements LocalDataPathSystem {
    private static final Object INIT_LOCK = new Object();
    private static boolean initialized;

    private static native String SHGetPathFromIDList(int var0);

    public static String getPath(CCIDL csidl) {
        return WindowsSystem.SHGetPathFromIDList(csidl.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsSystem() {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (!initialized) {
                System.loadLibrary("jdatapath");
                initialized = true;
            }
        }
    }

    @Override
    public DataPath getLocalDataPath(String wantedDataDirName) {
        String mainPath = WindowsSystem.getPath(CCIDL.CSIDL_LOCAL_APPDATA);
        return new DataPath(mainPath + JDataPathSystem.getFileSeparator() + wantedDataDirName, true);
    }

    @Override
    public DataPath getUserProfilePath() {
        return new DataPath(WindowsSystem.getPath(CCIDL.CSIDL_PROFILE), true);
    }
}

