/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.nio.ByteBuffer;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockType;
import org.apache.jena.dboe.base.buffer.PtrBuffer;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.page.BlockConverter;
import org.apache.jena.dboe.base.page.PageBlockMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeException;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;

public final class BPTreeNodeMgr
extends PageBlockMgr<BPTreeNode> {
    public BPTreeNodeMgr(BPlusTree bpTree, BlockMgr blockMgr) {
        super((BlockConverter)new Block2BPTreeNode(bpTree), blockMgr);
    }

    public BPTreeNode createNode(int parent) {
        BPTreeNode n = (BPTreeNode)this.create(BlockType.BPTREE_BRANCH);
        n.setIsLeaf(false);
        n.setParent(parent);
        return n;
    }

    public BPTreeNode getWrite(int id) {
        return (BPTreeNode)super.getWrite(id, -98);
    }

    public BPTreeNode getRead(int id) {
        return (BPTreeNode)super.getRead(id, -98);
    }

    public BPTreeNode getRead(int id, int parent) {
        BPTreeNode n = (BPTreeNode)super.getRead$(id);
        n.setParent(parent);
        return n;
    }

    public BPTreeNode getWrite(int id, int parent) {
        BPTreeNode n = (BPTreeNode)super.getWrite$(id);
        n.setParent(parent);
        return n;
    }

    boolean isWritable(int id) {
        return false;
    }

    private static final BlockType getType(int x) {
        return BlockType.extract((int)(x >>> 24));
    }

    private static final int encodeCount(BlockType type, int i) {
        return type.id() << 24 | i & 0xFFFFFF;
    }

    private static final int decodeCount(int i) {
        return i & 0xFFFFFF;
    }

    private static BPTreeNode overlay(BPlusTree bpTree, Block block, boolean asLeaf, int count) {
        BPTreeNode n = new BPTreeNode(bpTree);
        BPTreeNodeMgr.formatBPTreeNode(n, bpTree, block, asLeaf, -99, count);
        return n;
    }

    static void formatBPTreeNode(BPTreeNode n, BPlusTree bpTree, Block block, boolean leaf, int parent, int count) {
        int header;
        BPlusTreeParams params = bpTree.getParams();
        int ptrBuffLen = params.MaxPtr * params.getPtrLength();
        int recBuffLen = params.MaxRec * params.getRecordLength();
        n.id = block.getId().intValue();
        n.setParent(parent);
        n.setCount(count);
        n.setIsLeaf(leaf);
        int rStart = header = BPlusTreeParams.BlockHeaderSize;
        int pStart = header + recBuffLen;
        int numPtrs = -1;
        if (n.getCount() < 0) {
            numPtrs = 0;
            n.setCount(BPTreeNodeMgr.decodeCount(n.getCount()));
        } else {
            numPtrs = n.getCount() + 1;
        }
        n.block = block;
        ByteBuffer byteBuffer = block.getByteBuffer();
        byteBuffer.position(rStart);
        byteBuffer.limit(rStart + recBuffLen);
        ByteBuffer bbr = byteBuffer.slice();
        n.setRecordBuffer(new RecordBuffer(bbr, n.params.keyFactory, n.getCount()));
        byteBuffer.position(pStart);
        byteBuffer.limit(pStart + ptrBuffLen);
        ByteBuffer bbi = byteBuffer.slice();
        n.setPtrBuffer(new PtrBuffer(bbi, numPtrs));
        byteBuffer.rewind();
    }

    static final void formatForRoot(BPTreeNode n, boolean asLeaf) {
        BPTreeNodeMgr.formatBPTreeNode(n, n.bpTree, n.getBackingBlock(), asLeaf, -2, 0);
    }

    private static class Block2BPTreeNode
    implements BlockConverter<BPTreeNode> {
        private final BPlusTree bpTree;

        Block2BPTreeNode(BPlusTree bpTree) {
            this.bpTree = bpTree;
        }

        public BPTreeNode createFromBlock(Block block, BlockType bType) {
            return BPTreeNodeMgr.overlay(this.bpTree, block, bType == BlockType.RECORD_BLOCK, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BPTreeNode fromBlock(Block block) {
            Block block2 = block;
            synchronized (block2) {
                int x = block.getByteBuffer().getInt(0);
                BlockType type = BPTreeNodeMgr.getType(x);
                if (type != BlockType.BPTREE_BRANCH && type != BlockType.BPTREE_LEAF) {
                    throw new BPTreeException("Wrong block type: " + type);
                }
                int count = BPTreeNodeMgr.decodeCount(x);
                return BPTreeNodeMgr.overlay(this.bpTree, block, type == BlockType.BPTREE_LEAF, count);
            }
        }

        public Block toBlock(BPTreeNode node) {
            Block block = node.getBackingBlock();
            BlockType bType = node.isLeaf() ? BlockType.BPTREE_LEAF : BlockType.BPTREE_BRANCH;
            int c = BPTreeNodeMgr.encodeCount(bType, node.getCount());
            block.getByteBuffer().putInt(0, c);
            return block;
        }
    }
}

