/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;
import org.wikidata.wdtk.wikibaseapi.StatementUpdate;
import org.wikidata.wdtk.wikibaseapi.WbEditingAction;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class TermStatementUpdate
extends StatementUpdate {
    static final Logger logger = LoggerFactory.getLogger(TermStatementUpdate.class);
    protected final TermedStatementDocument currentDocument;
    @JsonIgnore
    final Map<String, NameWithUpdate> newLabels;
    @JsonIgnore
    final Map<String, NameWithUpdate> newDescriptions;
    @JsonIgnore
    final Map<String, AliasesWithUpdate> newAliases;

    public TermStatementUpdate(TermedStatementDocument currentDocument, List<Statement> addStatements, List<Statement> deleteStatements, List<MonolingualTextValue> addLabels, List<MonolingualTextValue> addDescriptions, List<MonolingualTextValue> addAliases, List<MonolingualTextValue> deleteAliases) {
        super((StatementDocument)currentDocument, addStatements, deleteStatements);
        this.currentDocument = currentDocument;
        this.newLabels = this.initUpdatesFromCurrentValues(currentDocument.getLabels().values());
        this.newDescriptions = this.initUpdatesFromCurrentValues(currentDocument.getDescriptions().values());
        this.newAliases = new HashMap<String, AliasesWithUpdate>();
        for (Map.Entry entry : currentDocument.getAliases().entrySet()) {
            this.newAliases.put((String)entry.getKey(), new AliasesWithUpdate(new ArrayList<MonolingualTextValue>((Collection)entry.getValue()), false));
        }
        this.processLabels(addLabels);
        this.processDescriptions(addDescriptions);
        this.processAliases(addAliases, deleteAliases);
    }

    protected Map<String, NameWithUpdate> initUpdatesFromCurrentValues(Collection<MonolingualTextValue> currentValues) {
        HashMap<String, NameWithUpdate> updates = new HashMap<String, NameWithUpdate>();
        for (MonolingualTextValue label : currentValues) {
            updates.put(label.getLanguageCode(), new NameWithUpdate(label, false));
        }
        return updates;
    }

    protected void processAliases(List<MonolingualTextValue> addAliases, List<MonolingualTextValue> deleteAliases) {
        for (MonolingualTextValue val : addAliases) {
            this.addAlias(val);
        }
        for (MonolingualTextValue val : deleteAliases) {
            this.deleteAlias(val);
        }
    }

    protected void deleteAlias(MonolingualTextValue alias) {
        String lang = alias.getLanguageCode();
        AliasesWithUpdate currentAliases = this.newAliases.get(lang);
        if (currentAliases != null) {
            currentAliases.aliases.remove(alias);
            currentAliases.deleted.add(alias);
            currentAliases.write = true;
        }
    }

    protected void addAlias(MonolingualTextValue alias) {
        String lang = alias.getLanguageCode();
        AliasesWithUpdate currentAliasesUpdate = this.newAliases.get(lang);
        NameWithUpdate currentLabel = this.newLabels.get(lang);
        if (currentLabel == null) {
            this.newLabels.put(lang, new NameWithUpdate(alias, true));
        } else if (!currentLabel.value.equals(alias)) {
            List<MonolingualTextValue> currentAliases;
            if (currentAliasesUpdate == null) {
                currentAliasesUpdate = new AliasesWithUpdate(new ArrayList<MonolingualTextValue>(), true);
            }
            if (!(currentAliases = currentAliasesUpdate.aliases).contains(alias)) {
                currentAliases.add(alias);
                currentAliasesUpdate.added.add(alias);
                currentAliasesUpdate.write = true;
            }
            this.newAliases.put(lang, currentAliasesUpdate);
        }
    }

    protected void processDescriptions(List<MonolingualTextValue> descriptions) {
        for (MonolingualTextValue description : descriptions) {
            NameWithUpdate currentValue = this.newDescriptions.get(description.getLanguageCode());
            if (currentValue != null && currentValue.value.equals(description)) continue;
            this.newDescriptions.put(description.getLanguageCode(), new NameWithUpdate(description, true));
        }
    }

    protected void processLabels(List<MonolingualTextValue> labels) {
        for (MonolingualTextValue label : labels) {
            String lang = label.getLanguageCode();
            NameWithUpdate currentValue = this.newLabels.get(lang);
            if (currentValue != null && currentValue.value.equals(label)) continue;
            this.newLabels.put(lang, new NameWithUpdate(label, true));
            AliasesWithUpdate currentAliases = this.newAliases.get(lang);
            if (currentAliases == null || !currentAliases.aliases.contains(label)) continue;
            this.deleteAlias(label);
        }
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, TermImpl> getLabelUpdates() {
        return this.getMonolingualUpdatedValues(this.newLabels);
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, TermImpl> getDescriptionUpdates() {
        return this.getMonolingualUpdatedValues(this.newDescriptions);
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, List<TermImpl>> getAliasUpdates() {
        HashMap<String, List<TermImpl>> updatedValues = new HashMap<String, List<TermImpl>>();
        for (Map.Entry<String, AliasesWithUpdate> entry : this.newAliases.entrySet()) {
            AliasesWithUpdate update = entry.getValue();
            if (!update.write) continue;
            ArrayList<TermImpl> convertedAliases = new ArrayList<TermImpl>();
            for (MonolingualTextValue alias : update.aliases) {
                convertedAliases.add(this.monolingualToJackson(alias));
            }
            updatedValues.put(entry.getKey(), convertedAliases);
        }
        return updatedValues;
    }

    @Override
    @JsonIgnore
    public boolean isEmptyEdit() {
        return super.isEmptyEdit() && this.getLabelUpdates().isEmpty() && this.getDescriptionUpdates().isEmpty() && this.getAliasUpdates().isEmpty();
    }

    public List<MonolingualTextValue> getAddedAliases(String language) {
        AliasesWithUpdate update = this.newAliases.get(language);
        if (update == null) {
            return Collections.emptyList();
        }
        return update.added;
    }

    public List<MonolingualTextValue> getRemovedAliases(String language) {
        AliasesWithUpdate update = this.newAliases.get(language);
        if (update == null) {
            return Collections.emptyList();
        }
        return update.deleted;
    }

    public TermedStatementDocument performEdit(WbEditingAction action, boolean editAsBot, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        Map<String, TermImpl> labelUpdates = this.getLabelUpdates();
        Map<String, TermImpl> descriptionUpdates = this.getDescriptionUpdates();
        Map<String, List<TermImpl>> aliasUpdates = this.getAliasUpdates();
        if (labelUpdates.isEmpty() && descriptionUpdates.isEmpty() && aliasUpdates.isEmpty()) {
            return (TermedStatementDocument)super.performEdit(action, editAsBot, summary, tags);
        }
        if (super.isEmptyEdit()) {
            if (labelUpdates.size() == 1 && descriptionUpdates.isEmpty() && aliasUpdates.isEmpty()) {
                String language = labelUpdates.keySet().iterator().next();
                MonolingualTextValue value = (MonolingualTextValue)labelUpdates.get(language);
                JsonNode response = action.wbSetLabel(this.currentDocument.getEntityId().getId(), null, null, null, language, value.getText(), editAsBot, this.currentDocument.getRevisionId(), summary, tags);
                MonolingualTextValue respondedLabel = (MonolingualTextValue)this.getDatamodelObjectFromResponse(response, Arrays.asList("entity", "labels", language), TermImpl.class);
                long revisionId = this.getRevisionIdFromResponse(response);
                return this.currentDocument.withRevisionId(revisionId).withLabel(respondedLabel);
            }
            if (labelUpdates.isEmpty() && descriptionUpdates.size() == 1 && aliasUpdates.isEmpty()) {
                String language = descriptionUpdates.keySet().iterator().next();
                MonolingualTextValue value = (MonolingualTextValue)descriptionUpdates.get(language);
                JsonNode response = action.wbSetDescription(this.currentDocument.getEntityId().getId(), null, null, null, language, value.getText(), editAsBot, this.currentDocument.getRevisionId(), summary, tags);
                MonolingualTextValue respondedDescription = (MonolingualTextValue)this.getDatamodelObjectFromResponse(response, Arrays.asList("entity", "descriptions", language), TermImpl.class);
                long revisionId = this.getRevisionIdFromResponse(response);
                return this.currentDocument.withRevisionId(revisionId).withDescription(respondedDescription);
            }
            if (labelUpdates.isEmpty() && descriptionUpdates.isEmpty() && aliasUpdates.size() == 1) {
                String language = aliasUpdates.keySet().iterator().next();
                List<MonolingualTextValue> addedValues = this.getAddedAliases(language);
                List<MonolingualTextValue> removedValues = this.getRemovedAliases(language);
                ArrayList<String> addedStrings = new ArrayList<String>(addedValues.size());
                for (MonolingualTextValue monolingualTextValue : addedValues) {
                    addedStrings.add(monolingualTextValue.getText());
                }
                ArrayList<String> removedStrings = new ArrayList<String>(removedValues.size());
                for (MonolingualTextValue v : removedValues) {
                    removedStrings.add(v.getText());
                }
                JsonNode jsonNode = action.wbSetAliases(this.currentDocument.getEntityId().getId(), null, null, null, language, addedStrings, removedStrings, null, editAsBot, this.currentDocument.getRevisionId(), summary, tags);
                long revisionId = this.getRevisionIdFromResponse(jsonNode);
                TermImpl[] respondedAliases = this.getDatamodelObjectFromResponse(jsonNode, Arrays.asList("entity", "aliases", language), TermImpl[].class);
                List<TermImpl> newAliases = Arrays.asList(respondedAliases);
                return this.currentDocument.withRevisionId(revisionId).withAliases(language, newAliases);
            }
        }
        EntityDocument response = action.wbEditEntity(this.currentDocument.getEntityId().getId(), null, null, null, this.getJsonUpdateString(), false, editAsBot, this.currentDocument.getRevisionId(), summary, tags);
        return (TermedStatementDocument)response;
    }

    protected Map<String, TermImpl> getMonolingualUpdatedValues(Map<String, NameWithUpdate> updates) {
        HashMap<String, TermImpl> updatedValues = new HashMap<String, TermImpl>();
        for (NameWithUpdate update : updates.values()) {
            if (!update.write) continue;
            updatedValues.put(update.value.getLanguageCode(), this.monolingualToJackson(update.value));
        }
        return updatedValues;
    }

    protected TermImpl monolingualToJackson(MonolingualTextValue monolingualTextValue) {
        return new TermImpl(monolingualTextValue.getLanguageCode(), monolingualTextValue.getText());
    }

    private static class AliasesWithUpdate {
        public List<MonolingualTextValue> aliases;
        public List<MonolingualTextValue> added;
        public List<MonolingualTextValue> deleted;
        public boolean write;

        public AliasesWithUpdate(List<MonolingualTextValue> aliases, boolean write) {
            this.aliases = aliases;
            this.write = write;
            this.added = new ArrayList<MonolingualTextValue>();
            this.deleted = new ArrayList<MonolingualTextValue>();
        }
    }

    private static class NameWithUpdate {
        public MonolingualTextValue value;
        public boolean write;

        public NameWithUpdate(MonolingualTextValue value, boolean write) {
            this.value = value;
            this.write = write;
        }
    }
}

