/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.BasicApiConnection;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesAction;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesActionData;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesSearchData;
import org.wikidata.wdtk.wikibaseapi.WbSearchEntitiesAction;
import org.wikidata.wdtk.wikibaseapi.WbSearchEntitiesResult;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WikibaseDataFetcher {
    final WbGetEntitiesAction wbGetEntitiesAction;
    final WbSearchEntitiesAction wbSearchEntitiesAction;
    final String siteIri;
    private final DocumentDataFilter filter = new DocumentDataFilter();
    int maxListSize = 50;

    public static WikibaseDataFetcher getWikidataDataFetcher() {
        return new WikibaseDataFetcher(BasicApiConnection.getWikidataApiConnection(), "http://www.wikidata.org/entity/");
    }

    public static WikibaseDataFetcher getWikimediaCommonsDataFetcher() {
        return new WikibaseDataFetcher(BasicApiConnection.getWikimediaCommonsApiConnection(), "http://commons.wikimedia.org/entity/");
    }

    public WikibaseDataFetcher(ApiConnection connection, String siteUri) {
        this.wbGetEntitiesAction = new WbGetEntitiesAction(connection, siteUri);
        this.wbSearchEntitiesAction = new WbSearchEntitiesAction(connection, siteUri);
        this.siteIri = siteUri;
    }

    public DocumentDataFilter getFilter() {
        return this.filter;
    }

    public EntityDocument getEntityDocument(String entityId) throws MediaWikiApiErrorException, IOException {
        return this.getEntityDocuments(entityId).get(entityId);
    }

    public Map<String, EntityDocument> getEntityDocuments(String ... entityIds) throws MediaWikiApiErrorException, IOException {
        return this.getEntityDocuments(Arrays.asList(entityIds));
    }

    public Map<String, EntityDocument> getEntityDocuments(List<String> entityIds) throws MediaWikiApiErrorException, IOException {
        boolean moreItems;
        HashMap<String, EntityDocument> result = new HashMap<String, EntityDocument>();
        ArrayList<String> newEntityIds = new ArrayList<String>(entityIds);
        boolean bl = moreItems = !newEntityIds.isEmpty();
        while (moreItems) {
            List<String> subListOfEntityIds;
            if (newEntityIds.size() <= this.maxListSize) {
                subListOfEntityIds = newEntityIds;
                moreItems = false;
            } else {
                subListOfEntityIds = newEntityIds.subList(0, this.maxListSize);
            }
            WbGetEntitiesActionData properties = new WbGetEntitiesActionData();
            properties.ids = ApiConnection.implodeObjects(subListOfEntityIds);
            result.putAll(this.getEntityDocumentMap(subListOfEntityIds.size(), properties));
            subListOfEntityIds.clear();
        }
        return result;
    }

    public EntityDocument getEntityDocumentByTitle(String siteKey, String title) throws MediaWikiApiErrorException, IOException {
        return this.getEntityDocumentsByTitle(siteKey, title).get(title);
    }

    public Map<String, EntityDocument> getEntityDocumentsByTitle(String siteKey, String ... titles) throws MediaWikiApiErrorException, IOException {
        return this.getEntityDocumentsByTitle(siteKey, Arrays.asList(titles));
    }

    public Map<String, EntityDocument> getEntityDocumentsByTitle(String siteKey, List<String> titles) throws MediaWikiApiErrorException, IOException {
        boolean moreItems;
        ArrayList<String> newTitles = new ArrayList<String>(titles);
        HashMap<String, EntityDocument> result = new HashMap<String, EntityDocument>();
        boolean bl = moreItems = !newTitles.isEmpty();
        while (moreItems) {
            List<String> subListOfTitles;
            if (newTitles.size() <= this.maxListSize) {
                subListOfTitles = newTitles;
                moreItems = false;
            } else {
                subListOfTitles = newTitles.subList(0, this.maxListSize);
            }
            WbGetEntitiesActionData properties = new WbGetEntitiesActionData();
            properties.titles = ApiConnection.implodeObjects(subListOfTitles);
            properties.sites = siteKey;
            result.putAll(this.getEntityDocumentMap(subListOfTitles.size(), properties));
            subListOfTitles.clear();
        }
        return result;
    }

    Map<String, EntityDocument> getEntityDocumentMap(int numOfEntities, WbGetEntitiesActionData properties) throws MediaWikiApiErrorException, IOException {
        if (numOfEntities == 0) {
            return Collections.emptyMap();
        }
        this.configureProperties(properties);
        return this.wbGetEntitiesAction.wbGetEntities(properties);
    }

    public List<WbSearchEntitiesResult> searchEntities(String search) throws MediaWikiApiErrorException, IOException {
        WbGetEntitiesSearchData properties = new WbGetEntitiesSearchData();
        properties.search = search;
        properties.language = "en";
        return this.searchEntities(properties);
    }

    public List<WbSearchEntitiesResult> searchEntities(String search, String language) throws MediaWikiApiErrorException, IOException {
        WbGetEntitiesSearchData properties = new WbGetEntitiesSearchData();
        properties.search = search;
        properties.language = language;
        return this.searchEntities(properties);
    }

    public List<WbSearchEntitiesResult> searchEntities(String search, Long limit) throws MediaWikiApiErrorException, IOException {
        WbGetEntitiesSearchData properties = new WbGetEntitiesSearchData();
        properties.search = search;
        properties.language = "en";
        properties.limit = limit;
        return this.searchEntities(properties);
    }

    public List<WbSearchEntitiesResult> searchEntities(String search, String language, Long limit) throws MediaWikiApiErrorException, IOException {
        WbGetEntitiesSearchData properties = new WbGetEntitiesSearchData();
        properties.search = search;
        properties.language = language;
        properties.limit = limit;
        return this.searchEntities(properties);
    }

    public List<WbSearchEntitiesResult> searchEntities(WbGetEntitiesSearchData properties) throws MediaWikiApiErrorException, IOException {
        return this.wbSearchEntitiesAction.wbSearchEntities(properties);
    }

    void configureProperties(WbGetEntitiesActionData properties) {
        this.setRequestProps(properties);
        this.setRequestLanguages(properties);
        this.setRequestSitefilter(properties);
    }

    private void setRequestProps(WbGetEntitiesActionData properties) {
        StringBuilder builder = new StringBuilder();
        builder.append("info|datatype");
        if (!this.filter.excludeAllLanguages()) {
            builder.append("|labels|aliases|descriptions");
        }
        if (!this.filter.excludeAllProperties()) {
            builder.append("|claims");
        }
        if (!this.filter.excludeAllSiteLinks()) {
            builder.append("|sitelinks");
        }
        properties.props = builder.toString();
    }

    private void setRequestLanguages(WbGetEntitiesActionData properties) {
        if (this.filter.excludeAllLanguages() || this.filter.getLanguageFilter() == null) {
            return;
        }
        properties.languages = ApiConnection.implodeObjects(this.filter.getLanguageFilter());
    }

    private void setRequestSitefilter(WbGetEntitiesActionData properties) {
        if (this.filter.excludeAllSiteLinks() || this.filter.getSiteLinkFilter() == null) {
            return;
        }
        properties.sitefilter = ApiConnection.implodeObjects(this.filter.getSiteLinkFilter());
    }
}

