/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.expr;

import com.metaweb.lessen.Scope;
import com.metaweb.lessen.expr.Evaluable;
import com.metaweb.lessen.tokens.Color;
import com.metaweb.lessen.tokens.NumericToken;
import com.metaweb.lessen.tokens.NumericWithUnitToken;
import com.metaweb.lessen.tokens.OneTokenColor;
import com.metaweb.lessen.tokens.Token;

public class OperatorCall
implements Evaluable {
    protected final String _operator;
    protected final Evaluable _left;
    protected final Evaluable _right;

    public OperatorCall(String operator, Evaluable left, Evaluable right) {
        this._operator = operator;
        this._left = left;
        this._right = right;
    }

    public Token eval(Scope scope) {
        NumericToken t;
        Color c;
        Token right;
        Token left = this._left != null ? this._left.eval(scope) : null;
        Token token = right = this._right != null ? this._right.eval(scope) : null;
        if (left != null && (c = OneTokenColor.tokenToColor(left)) != null) {
            left = c;
        }
        if (right != null && (c = OneTokenColor.tokenToColor(right)) != null) {
            right = c;
        }
        if (left != null && left instanceof Color) {
            if (right != null) {
                if (right instanceof Color) {
                    if (this._operator.equals("+") || this._operator.equals("-")) {
                        return ((Color)left).performOperation(this._operator, (Color)right);
                    }
                } else if (right instanceof NumericToken) {
                    t = (NumericToken)right;
                    if (this._operator.equals("*") || this._operator.equals("/")) {
                        if (t.type == Token.Type.Number) {
                            return ((Color)left).performOperation(this._operator, t.n);
                        }
                        if (t.type == Token.Type.Percentage) {
                            return ((Color)left).performOperation(this._operator, t.n.doubleValue() / 100.0);
                        }
                    } else if ((this._operator.equals("+") || this._operator.equals("-")) && t.type == Token.Type.Percentage) {
                        return ((Color)left).performOperation("*", 1.0 + (double)(this._operator.equals("+") ? 1 : -1) * t.n.doubleValue() / 100.0);
                    }
                }
            }
            return null;
        }
        if (right != null && right instanceof Color) {
            if (left != null && this._operator.equals("*") && left instanceof NumericToken) {
                t = (NumericToken)left;
                if (t.type == Token.Type.Number) {
                    return ((Color)right).performOperation(this._operator, t.n);
                }
                if (t.type == Token.Type.Percentage) {
                    return ((Color)right).performOperation(this._operator, t.n.doubleValue() / 100.0);
                }
            }
            return null;
        }
        if (left != null && left instanceof NumericToken) {
            if (right != null) {
                NumericToken rightT;
                NumericToken resultT;
                NumericToken leftT = (NumericToken)left;
                if (right instanceof NumericToken && (resultT = OperatorCall.performNumericOperation(this._operator, leftT, rightT = (NumericToken)right)) != null) {
                    return resultT;
                }
            }
            return null;
        }
        return null;
    }

    public static NumericToken performNumericOperation(String op, NumericToken leftT, double n) {
        double leftN = leftT.n.doubleValue();
        if (op.equals("+")) {
            return OperatorCall.makeNumericToken(leftT, leftN + n);
        }
        if (op.equals("-")) {
            return OperatorCall.makeNumericToken(leftT, leftN - n);
        }
        if (op.equals("*")) {
            return OperatorCall.makeNumericToken(leftT, leftN * n);
        }
        if (op.equals("/")) {
            return OperatorCall.makeNumericToken(leftT, leftN / n);
        }
        return null;
    }

    public static NumericToken performNumericOperation(String op, NumericToken leftT, NumericToken rightT) {
        double leftN = leftT.n.doubleValue();
        double rightN = rightT.n.doubleValue();
        if (leftT.type == Token.Type.Number) {
            if (rightT.type == Token.Type.Number) {
                return OperatorCall.performNumericOperation(op, leftT, rightN);
            }
            if (rightT.type == Token.Type.Percentage) {
                if (op.equals("+")) {
                    return OperatorCall.makeNumberToken(leftT, leftN * (1.0 + rightN / 100.0));
                }
                if (op.equals("-")) {
                    return OperatorCall.makeNumberToken(leftT, leftN * (1.0 - rightN / 100.0));
                }
                if (op.equals("*")) {
                    return OperatorCall.makePercentageToken(leftT, leftN * rightN);
                }
            } else if (rightT.type == Token.Type.Dimension) {
                String rightUnit = ((NumericWithUnitToken)rightT).unit;
                if (op.equals("+")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN + rightN, rightUnit);
                }
                if (op.equals("-")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN - rightN, rightUnit);
                }
                if (op.equals("*")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN * rightN, rightUnit);
                }
            }
        } else if (leftT.type == Token.Type.Percentage) {
            if (rightT.type == Token.Type.Number || rightT.type == Token.Type.Percentage) {
                if (op.equals("+")) {
                    return OperatorCall.makePercentageToken(leftT, leftN + rightN);
                }
                if (op.equals("-")) {
                    return OperatorCall.makePercentageToken(leftT, leftN - rightN);
                }
                if (op.equals("*")) {
                    return OperatorCall.makePercentageToken(leftT, leftN * rightN);
                }
                if (op.equals("/")) {
                    return OperatorCall.makePercentageToken(leftT, leftN / rightN);
                }
            } else if (rightT.type == Token.Type.Dimension) {
                String rightUnit = ((NumericWithUnitToken)rightT).unit;
                if (op.equals("*")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN * rightN / 100.0, rightUnit);
                }
            }
        } else if (leftT.type == Token.Type.Dimension) {
            String leftUnit = ((NumericWithUnitToken)leftT).unit;
            if (rightT.type == Token.Type.Percentage) {
                if (op.equals("+")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN * (1.0 + rightN / 100.0), leftUnit);
                }
                if (op.equals("-")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN * (1.0 - rightN / 100.0), leftUnit);
                }
                if (op.equals("*")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN * rightN, leftUnit);
                }
            } else if (rightT.type == Token.Type.Number || rightT.type == Token.Type.Dimension && leftUnit.equals(((NumericWithUnitToken)rightT).unit)) {
                if (op.equals("+")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN + rightN, leftUnit);
                }
                if (op.equals("-")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN - rightN, leftUnit);
                }
                if (op.equals("*")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN * rightN, leftUnit);
                }
                if (op.equals("/")) {
                    return OperatorCall.makeDimensionToken(leftT, leftN / rightN, leftUnit);
                }
            }
        }
        return null;
    }

    public static NumericToken makeNumericToken(Token t, double d) {
        return t.type == Token.Type.Percentage ? OperatorCall.makePercentageToken(t, d) : OperatorCall.makeNumberToken(t, d);
    }

    public static NumericToken makeNumberToken(Token t, double d) {
        Number n = OperatorCall.doubleToNumber(d);
        return new NumericToken(Token.Type.Number, t.start, t.end, n.toString(), n);
    }

    public static NumericToken makePercentageToken(Token t, double d) {
        Number n = OperatorCall.doubleToNumber(d);
        return new NumericToken(Token.Type.Percentage, t.start, t.end, n.toString() + "%", n);
    }

    public static NumericToken makeDimensionToken(Token t, double d, String unit) {
        Number n = OperatorCall.doubleToNumber(d);
        return new NumericWithUnitToken(Token.Type.Dimension, t.start, t.end, n.toString() + unit, n, unit);
    }

    public static Number doubleToNumber(double n) {
        if (n - (double)Math.round(n) == 0.0) {
            return Math.round(n);
        }
        return n;
    }
}

