/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;
import com.metaweb.lessen.tokens.UriToken;

public class UrlRewritingTokenizer
implements Tokenizer {
    protected final Tokenizer _tokenizer;
    protected final String _relativePath;
    protected final String[] _segments;
    protected Token _token;

    public UrlRewritingTokenizer(Tokenizer tokenizer, String relativePath) {
        this._tokenizer = tokenizer;
        this._relativePath = relativePath;
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        this._segments = this._relativePath.split("/");
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    public Token getToken() {
        return this._token;
    }

    public void next() {
        this._tokenizer.next();
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    protected void resolve() {
        if (this._token != null && this._token.type == Token.Type.Uri) {
            String url;
            UriToken t = (UriToken)this._token;
            if (t.prefix.equals("url") && (url = t.unquotedText).indexOf("://") < 0 && !url.startsWith("/")) {
                int lastSegment = this._segments.length;
                while (url.length() > 0) {
                    if (url.startsWith("./")) {
                        url = url.substring(2);
                        continue;
                    }
                    if (!url.startsWith("../")) break;
                    url = url.substring(3);
                    --lastSegment;
                }
                StringBuffer sb = new StringBuffer();
                if (lastSegment > 0) {
                    for (int i = 0; i < lastSegment; ++i) {
                        sb.append(this._segments[i]);
                        sb.append('/');
                    }
                } else {
                    while (lastSegment < 0) {
                        sb.append("../");
                        ++lastSegment;
                    }
                }
                String url2 = sb.toString() + url;
                String text = t.prefix + "(\"" + url2 + "\")";
                this._token = new UriToken(t.start, t.end, text, t.prefix, url2);
            }
        }
    }
}

