/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.StringValueToken;
import com.metaweb.lessen.tokens.Token;
import com.metaweb.lessen.tokens.UriToken;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableResolvingTokenizer
implements Tokenizer {
    protected final BufferedTokenizer _tokenizer;
    protected final Map<String, String> _variables;
    protected final boolean _resolveURIs;
    protected Token _token;

    public VariableResolvingTokenizer(Tokenizer tokenizer, Map<String, String> variables) {
        this(tokenizer, variables, true);
    }

    public VariableResolvingTokenizer(Tokenizer tokenizer, Map<String, String> variables, boolean resolveURIs) {
        this._tokenizer = new BufferedTokenizer(tokenizer);
        this._variables = variables;
        this._resolveURIs = resolveURIs;
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    @Override
    public Token getToken() {
        return this._token;
    }

    @Override
    public void next() {
        this._tokenizer.next();
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    protected void resolve() {
        if (this._token != null) {
            Token newToken;
            Token nextToken;
            Token.Type type = this._token.type;
            if (type == Token.Type.Uri) {
                UriToken uriToken = (UriToken)this._token;
                if (uriToken.prefix.equals("url")) {
                    String url2;
                    int dollar;
                    String url = uriToken.unquotedText;
                    StringBuffer sb = new StringBuffer();
                    int start = 0;
                    while (start < url.length() && (dollar = url.indexOf(36, start)) >= 0 && dollar != url.length() - 1) {
                        String name;
                        int n;
                        sb.append(url.substring(start, dollar));
                        if (url.charAt(dollar + 1) == '{') {
                            for (n = dollar + 2; n < url.length() && url.charAt(n) != '}'; ++n) {
                            }
                            name = url.substring(dollar + 2, n);
                            start = n + 1;
                        } else {
                            char c;
                            for (n = dollar + 1; n < url.length() && (Character.isLetter(c = url.charAt(n)) || Character.isDigit(c) || c == '_'); ++n) {
                            }
                            name = url.substring(dollar + 1, n);
                            start = n;
                        }
                        sb.append(this.resolveVariable(name));
                    }
                    if (start < url.length()) {
                        sb.append(url.substring(start));
                    }
                    if (!(url2 = sb.toString()).equals(url)) {
                        String text = uriToken.prefix + "(\"" + url2 + "\")";
                        this._token = new UriToken(uriToken.start, uriToken.end, text, uriToken.prefix, url2);
                    }
                }
                return;
            }
            StringBuffer sb = new StringBuffer();
            if (type == Token.Type.Operator && this._token.text.equals("#")) {
                Token nextToken2 = this._tokenizer.getToken(1);
                if (nextToken2 == null || nextToken2.type != Token.Type.Variable) {
                    return;
                }
                sb.append("#");
                type = Token.Type.HashName;
            } else if (type == Token.Type.Variable) {
                sb.append(this.resolveVariable(this._token));
            } else if (type == Token.Type.HashName || type == Token.Type.Identifier || type == Token.Type.AtIdentifier) {
                sb.append(this._token.text);
            } else {
                return;
            }
            int tokenEnd = this._token.end;
            while ((nextToken = this._tokenizer.getToken(1)) != null) {
                if (nextToken.type == Token.Type.Variable) {
                    sb.append(this.resolveVariable(nextToken));
                    tokenEnd = nextToken.end;
                    this._tokenizer.next();
                    continue;
                }
                if (nextToken.type != Token.Type.Identifier) break;
                sb.append(nextToken.text);
                tokenEnd = nextToken.end;
                this._tokenizer.next();
            }
            this._token = newToken = new Token(type, this._token.start, tokenEnd, sb.toString());
        }
    }

    protected String resolveVariable(Token t) {
        return this.resolveVariable(((StringValueToken)t).unquotedText);
    }

    protected String resolveVariable(String name) {
        String resolved = this._variables.get(name);
        if (resolved == null) {
            resolved = "UNDEFINED_VARIABLE";
        }
        return resolved;
    }
}

