/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import java.net.URL;

public class Zone {
    private String name;
    private String protocol;
    private String host;
    private String path;
    private String prefix;
    private String full;

    public Zone(String name, String zonePath) {
        this.name = name;
        int index = zonePath.indexOf("://");
        if (index > 0) {
            try {
                URL url = new URL(zonePath);
                this.protocol = url.getProtocol();
                this.host = url.getHost();
                this.path = url.getPath();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse the zone path '" + zonePath + "', make sure it's a valid HTTP URL or an absolute path.", e);
            }
        } else {
            this.path = zonePath;
        }
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        StringBuffer b = new StringBuffer();
        if (this.protocol != null) {
            b.append(this.protocol);
            b.append("://");
        }
        if (this.host != null) {
            b.append(this.host);
        }
        this.prefix = b.toString();
        b.append(this.path);
        this.full = b.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.full;
    }
}

