/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.WtEntityMapImpl;
import org.sweble.wikitext.parser.encval.EncodingValidatorLexer;
import org.sweble.wikitext.parser.encval.ValidatedWikitext;

public class WikitextEncodingValidator {
    public ValidatedWikitext validate(ParserConfig parserConfig, WtEntityMap entityMap, String title, String source) throws IOException {
        StringReader in = new StringReader(source);
        EncodingValidatorLexer lexer = new EncodingValidatorLexer(in);
        lexer.setFile(title);
        lexer.setEntityMap(entityMap);
        lexer.setWikitextNodeFactory(parserConfig.getNodeFactory());
        lexer.setConvertIllegalCodePoints(parserConfig.isConvertIllegalCodePoints());
        while (lexer.yylex() != null) {
        }
        in.close();
        return new ValidatedWikitext(lexer.getWikitext(), entityMap, lexer.containsIllegalCodePoints());
    }

    public ValidatedWikitext validate(ParserConfig parserConfig, WtEntityMap entityMap, String title, Reader source) throws IOException {
        EncodingValidatorLexer lexer = new EncodingValidatorLexer(source);
        lexer.setFile(title);
        lexer.setEntityMap(entityMap);
        lexer.setWikitextNodeFactory(parserConfig.getNodeFactory());
        while (lexer.yylex() != null) {
        }
        return new ValidatedWikitext(lexer.getWikitext(), entityMap, lexer.containsIllegalCodePoints());
    }

    public ValidatedWikitext validate(ParserConfig parserConfig, String source, String title) throws IOException {
        return this.validate(parserConfig, (WtEntityMap)new WtEntityMapImpl(), title, source);
    }

    public ValidatedWikitext validate(ParserConfig parserConfig, Reader source, String title) throws IOException {
        return this.validate(parserConfig, (WtEntityMap)new WtEntityMapImpl(), title, source);
    }
}

