/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.parser;

import de.fau.cs.osr.ptk.common.Warning;
import java.util.ArrayList;
import java.util.ListIterator;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtLinkOptionGarbage;
import org.sweble.wikitext.parser.nodes.WtLinkOptionKeyword;
import org.sweble.wikitext.parser.nodes.WtLinkOptionResize;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtPageName;

public class LinkBuilder {
    private final WtPageName target;
    private int width;
    private int height;
    private boolean upright;
    private WtImageLink.ImageHorizAlign hAlign;
    private WtImageLink.ImageVertAlign vAlign;
    private WtImageLink.ImageViewFormat format;
    private boolean border;
    private ArrayList<Warning> warnings;
    private final ParserConfig parserConfig;
    private final LinkType targetType;

    public LinkBuilder(ParserConfig parserConfig, WtPageName target) {
        this.target = target;
        this.parserConfig = parserConfig;
        LinkType targetType = LinkType.INVALID;
        if (target.isResolved()) {
            targetType = parserConfig.classifyTarget(target.getAsString());
        }
        this.targetType = targetType;
        this.width = -1;
        this.height = -1;
        this.upright = false;
        this.hAlign = null;
        this.vAlign = null;
        this.format = null;
        this.border = false;
    }

    public boolean isImageTarget() {
        return this.targetType == LinkType.IMAGE;
    }

    public boolean isValidTarget() {
        return this.targetType != LinkType.INVALID;
    }

    public boolean isKeyword(String keyword) {
        return WtImageLink.ImageViewFormat.which(keyword) != null || WtImageLink.ImageHorizAlign.which(keyword) != null || WtImageLink.ImageVertAlign.which(keyword) != null || keyword.equals("border") || keyword.equals("upright");
    }

    public void addOption(WtLinkOptionKeyword option) {
        String keyword = option.getKeyword();
        WtImageLink.ImageViewFormat f = WtImageLink.ImageViewFormat.which(keyword);
        if (f != null) {
            this.format = this.format == null ? f : this.format.combine(f);
        } else {
            WtImageLink.ImageHorizAlign h = WtImageLink.ImageHorizAlign.which(keyword);
            if (h != null) {
                this.hAlign = h;
            } else {
                WtImageLink.ImageVertAlign v = WtImageLink.ImageVertAlign.which(keyword);
                if (v != null) {
                    this.vAlign = v;
                } else if (keyword.equals("border")) {
                    this.border = true;
                } else if (keyword.equals("upright")) {
                    this.upright = true;
                }
            }
        }
    }

    public void addOption(WtLinkOptionResize option) {
        int height;
        int width = option.getWidth();
        if (width >= 0) {
            this.width = width;
        }
        if ((height = option.getHeight()) >= 0) {
            this.height = height;
        }
    }

    public void addWarning(Warning warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        this.warnings.add(warning);
    }

    public WtNode build(WtLinkOptions options, String postfix) {
        WtLinkTitle title = this.findTitle(options);
        if (this.targetType == LinkType.IMAGE) {
            if (this.hAlign == null) {
                this.hAlign = WtImageLink.ImageHorizAlign.UNSPECIFIED;
            }
            if (this.vAlign == null) {
                this.vAlign = WtImageLink.ImageVertAlign.MIDDLE;
            }
            if (this.format == null) {
                this.format = WtImageLink.ImageViewFormat.UNRESTRAINED;
            }
            WtImageLink result = this.parserConfig.getNodeFactory().img(this.target, options, this.format, this.border, this.hAlign, this.vAlign, this.width, this.height, this.upright);
            this.finish(result);
            return result;
        }
        if (postfix == null) {
            postfix = "";
        }
        WtInternalLink result = this.parserConfig.getNodeFactory().intLink("", this.target, postfix);
        if (title != null) {
            result.setTitle(title);
        }
        this.finish(result);
        return result;
    }

    private WtLinkTitle findTitle(WtLinkOptions options) {
        ListIterator i = options.listIterator(options.size());
        WtLinkTitle title = null;
        while (i.hasPrevious()) {
            WtNode n = (WtNode)i.previous();
            if (n.getNodeType() != 720910) continue;
            if (title == null) {
                title = (WtLinkTitle)n;
                continue;
            }
            WtLinkOptionGarbage garbage = this.parserConfig.getNodeFactory().loGarbage(this.parserConfig.getNodeFactory().list());
            garbage.exchange((WtLinkTitle)n);
            garbage.setRtd(n.getRtd());
            i.set(garbage);
        }
        return title;
    }

    public void finish(WtNode n) {
        if (this.warnings != null && !this.warnings.isEmpty()) {
            n.setAttribute("warnings", this.warnings);
        }
    }

    public static enum LinkType {
        INVALID,
        PAGE,
        IMAGE;

    }
}

