/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.utils;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.utils.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sweble.wikitext.parser.nodes.WtNode;

public class NodeStats {
    public static void process(WtNode astNode) {
        new NodeStatsVisitor().go(astNode);
    }

    protected static final class NodeStatsVisitor
    extends AstVisitor<WtNode> {
        private final Map<String, Integer> nodeCounts = new HashMap<String, Integer>();
        private int varCount = 0;
        private int varEmptyCount = 0;
        private int varChildCount = 0;
        private int varMaxChildCount = -1;
        private int fixCount = 0;
        private int fixChildCount = 0;
        private int leafCount = 0;

        protected NodeStatsVisitor() {
        }

        protected Object after(WtNode node, Object result) {
            System.out.println("Analysis:");
            ArrayList<String> nodeNames = new ArrayList<String>(this.nodeCounts.keySet());
            Collections.sort(nodeNames);
            int sum = 0;
            for (String name : nodeNames) {
                int count = this.nodeCounts.get(name);
                sum += count;
                String space = StringTools.strrep((char)'.', (int)(80 - name.length()));
                System.out.format("  %s %s %5d\n", name, space, count);
            }
            System.out.println("  " + StringTools.strrep((char)'=', (int)87));
            System.out.format("  %s%5d\n", StringTools.strrep((char)' ', (int)82), sum);
            System.out.println();
            System.out.println("  Nodes with variable number of children: ");
            System.out.format("     Count:   %5d\n", this.varCount);
            System.out.format("     Leaf:    %5d\n", this.varEmptyCount);
            System.out.format("     Biggest: %5d\n", this.varMaxChildCount);
            System.out.format("     Average:    %5.2f\n", Float.valueOf((float)this.varChildCount / (float)(this.varCount - this.varEmptyCount)));
            System.out.println();
            System.out.println("  Nodes with fixed number of children: ");
            System.out.format("     Inner:   %5d\n", this.fixCount);
            System.out.format("     Leafs:   %5d\n", this.leafCount);
            System.out.format("     Average:    %5.2f\n", Float.valueOf((float)this.fixChildCount / (float)this.fixCount));
            return super.after((Object)node, result);
        }

        public void visit(WtNode n) {
            if (n != null) {
                this.countNode(n);
                int size = n.size();
                if (n.isList()) {
                    ++this.varCount;
                    this.varChildCount += size;
                    if (n.isEmpty()) {
                        ++this.varEmptyCount;
                    }
                    if (size > this.varMaxChildCount) {
                        this.varMaxChildCount = size;
                    }
                } else if (!n.isEmpty()) {
                    ++this.fixCount;
                    this.fixChildCount += size;
                } else {
                    ++this.leafCount;
                }
                this.iterate(n);
            }
        }

        private void countNode(WtNode n) {
            Class<?> clazz = n.getClass();
            String name = clazz.getName();
            Integer i = this.nodeCounts.get(name);
            if (i == null) {
                i = 0;
            }
            this.nodeCounts.put(name, i + 1);
        }
    }
}

