/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;

public class TransactionalMRSW
extends TransactionalComponentLifecycle<Object> {
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public TransactionalMRSW(ComponentId componentId) {
        super(componentId);
    }

    @Override
    public void startRecovery() {
    }

    @Override
    public void recover(ByteBuffer ref) {
        Log.warn((Object)this, (String)"Called to recover a transaction (ignored)");
    }

    @Override
    public void finishRecovery() {
    }

    @Override
    public void cleanStart() {
    }

    private Lock getLock() {
        return ReadWrite.WRITE.equals((Object)this.getReadWriteMode()) ? this.lock.writeLock() : this.lock.readLock();
    }

    @Override
    protected Object _begin(ReadWrite readWrite, TxnId thisTxnId) {
        Lock lock = this.getLock();
        lock.lock();
        if (this.isWriteTxn()) {
            this.startWriteTxn();
        } else {
            this.startReadTxn();
        }
        return this.createState();
    }

    private Object createState() {
        return new Object();
    }

    @Override
    protected Object _promote(TxnId txnId, Object state) {
        boolean b = this.lock.writeLock().tryLock();
        if (!b) {
            Log.warn((Object)this, (String)"Failed to promote");
            return false;
        }
        this.lock.readLock().unlock();
        return this.createState();
    }

    protected void startReadTxn() {
    }

    protected void startWriteTxn() {
    }

    protected void finishReadTxn() {
    }

    protected void finishWriteTxn() {
    }

    @Override
    protected ByteBuffer _commitPrepare(TxnId txnId, Object obj) {
        return null;
    }

    @Override
    protected void _commit(TxnId txnId, Object obj) {
        this.clearup();
    }

    @Override
    protected void _commitEnd(TxnId txnId, Object obj) {
        this.clearup();
    }

    @Override
    protected void _abort(TxnId txnId, Object obj) {
        this.clearup();
    }

    @Override
    protected void _complete(TxnId txnId, Object obj) {
    }

    @Override
    protected void _shutdown() {
        this.lock = null;
    }

    private void clearup() {
        Lock lock = this.getLock();
        if (this.isWriteTxn()) {
            this.finishWriteTxn();
        } else {
            this.finishReadTxn();
        }
        lock.unlock();
    }
}

