/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.demo;

import com.wcohen.ss.BasicStringWrapperIterator;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.SoftTFIDF;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.util.ArrayList;

public class SampleSoftTFIDFUsage {
    public static void main(String[] args) {
        SimpleTokenizer tokenizer = new SimpleTokenizer(false, true);
        double minTokenSimilarity = 0.8;
        SoftTFIDF distance = new SoftTFIDF(tokenizer, new JaroWinkler(), 0.8);
        String[] corpus = new String[]{"Yahoo Research", "Microsoft Research", "IBM Research", "Google Labs", "Bell Labs", "NEC Research Labs"};
        ArrayList<StringWrapper> list = new ArrayList<StringWrapper>();
        for (int i = 0; i < corpus.length; ++i) {
            list.add(distance.prepare(corpus[i]));
        }
        distance.train(new BasicStringWrapperIterator(list.iterator()));
        SampleSoftTFIDFUsage.myCompare(distance, "Microsoft Labs", "Microsoft Research");
        SampleSoftTFIDFUsage.myCompare(distance, "IBM Research", "Yahoo Research");
        SampleSoftTFIDFUsage.myCompare(distance, "Microsoft Reseach", "Microsafe Research");
        SampleSoftTFIDFUsage.myCompare(distance, "Google Labs", "Googel Research");
    }

    static void myCompare(SoftTFIDF distance, String s, String t) {
        double d = distance.score(s, t);
        System.out.println("========================================");
        System.out.println("String s:  '" + s + "'");
        System.out.println("String t:  '" + t + "'");
        System.out.println("Similarity: " + d);
        System.out.println("Explanation:\n" + distance.explainScore(s, t));
        double e = distance.score(distance.prepare(s), distance.prepare(t));
    }
}

