/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.setup.TDBDatasetDetails;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.tupletable.TupleTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRDFBatchSplit
implements StreamRDF {
    private static Logger log = LoggerFactory.getLogger(StreamRDFBatchSplit.class);
    protected static NodeId placeholder = NodeIdFactory.genUnique();
    protected final List<Triple> triples;
    protected final List<Tuple<NodeId>> tuples;
    protected final Map<Node, NodeId> mapping;
    private final int batchSize;
    private final TDBDatasetDetails details;
    private final DatasetGraphTDB dsg;
    private Transaction txn = null;
    int batchNumber = 0;

    public StreamRDFBatchSplit(DatasetGraphTDB dsg, int batchSize) {
        this.dsg = dsg;
        this.batchSize = batchSize;
        this.triples = new ArrayList<Triple>(batchSize);
        this.tuples = new ArrayList<Tuple<NodeId>>(this.triples.size());
        this.mapping = new HashMap<Node, NodeId>(2 * batchSize);
        this.details = new TDBDatasetDetails(dsg);
    }

    public void start() {
        log.info("Batch size: " + this.batchSize);
        if (this.txn == null) {
            this.txn = this.dsg.getTxnSystem().getThreadTransaction();
        }
        if (this.txn == null) {
            throw new TDBException("Not in a transaction");
        }
    }

    public void triple(Triple triple) {
        this.processNode(triple.getSubject());
        this.processNode(triple.getPredicate());
        this.processNode(triple.getObject());
        this.triples.add(triple);
        if (this.triples.size() >= this.batchSize) {
            this.processBatch();
        }
    }

    protected void processBatch() {
        ++this.batchNumber;
        Set<Node> requiredNodes = this.mapping.keySet();
        boolean executeBatchNodesPhase = true;
        boolean executeIndexPhase = true;
        boolean batchUpdateIndexes = true;
        if (executeBatchNodesPhase) {
            StreamRDFBatchSplit.batchUpdateNodes(requiredNodes, this.details);
        }
        if (executeIndexPhase) {
            if (batchUpdateIndexes) {
                StreamRDFBatchSplit.batchUpdateIndexes(this.dsg, this.details, this.triples, null);
            } else {
                StreamRDFBatchSplit.incrementalUpdateIndexes(this.triples, this.dsg);
            }
        }
        this.triples.clear();
        this.tuples.clear();
        this.mapping.clear();
    }

    private static void incrementalUpdateIndexes(List<Triple> triples, DatasetGraphTDB dsg) {
        for (Triple triple : triples) {
            dsg.getTripleTable().add(triple);
        }
    }

    private static void batchUpdateNodes(Set<Node> required, TDBDatasetDetails details) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node n : required) {
            if (details.ntCache.getNodeIdForNodeCache(n) != null) continue;
            nodes.add(n);
        }
        details.ntTop.bulkNodeToNodeId(nodes, true);
        for (Node n : required) {
            if (details.ntCache.getNodeIdForNodeCache(n) != null) continue;
            log.info("Not in cache: " + n);
        }
    }

    private static void batchUpdateIndexes(DatasetGraphTDB dsg, TDBDatasetDetails details, List<Triple> batchTriples, List<Tuple<NodeId>> workspace) {
        List<Tuple<NodeId>> tuples = workspace;
        if (tuples == null) {
            tuples = new ArrayList<Tuple<NodeId>>(batchTriples.size());
        }
        StreamRDFBatchSplit.convert(batchTriples, tuples, details.ntTop);
        TupleTable tupleTable = dsg.getTripleTable().getNodeTupleTable().getTupleTable();
        tupleTable.addAll(tuples);
    }

    private static List<Tuple<NodeId>> convert(List<Triple> triples, NodeTable nodeTable) {
        return triples.stream().map(t -> TupleFactory.tuple((Object[])new NodeId[]{nodeTable.getAllocateNodeId(t.getSubject()), nodeTable.getAllocateNodeId(t.getPredicate()), nodeTable.getAllocateNodeId(t.getObject())})).collect(Collectors.toList());
    }

    private static void convert(List<Triple> triples, List<Tuple<NodeId>> tuples, NodeTable nodeTable) {
        for (Triple t : triples) {
            NodeId nid_s = nodeTable.getAllocateNodeId(t.getSubject());
            NodeId nid_p = nodeTable.getAllocateNodeId(t.getPredicate());
            NodeId nid_o = nodeTable.getAllocateNodeId(t.getObject());
            Tuple x = TupleFactory.tuple((Object[])new NodeId[]{nid_s, nid_p, nid_o});
            tuples.add((Tuple<NodeId>)x);
        }
    }

    private void processNode(Node node) {
        NodeId nodeId;
        if (this.mapping.containsKey(node)) {
            return;
        }
        if (NodeId.hasInlineDatatype(node) && (nodeId = NodeId.inline(node)) != null) {
            return;
        }
        this.mapping.put(node, placeholder);
    }

    public void quad(Quad quad) {
    }

    public void base(String base) {
    }

    public void prefix(String prefix, String iri) {
    }

    public void finish() {
        if (!this.triples.isEmpty()) {
            this.processBatch();
        }
    }
}

