/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.setup;

import java.io.File;
import java.io.FileFilter;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.trans.data.TransBinaryDataFile;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionalBase;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.setup.ComponentIdMgr;
import org.apache.jena.tdb2.setup.StoreParams;
import org.apache.jena.tdb2.solver.OpExecutorTDB1;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.DatasetGraphTxn;
import org.apache.jena.tdb2.store.DatasetPrefixesTDB;
import org.apache.jena.tdb2.store.QuadTable;
import org.apache.jena.tdb2.store.TripleTable;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableCache;
import org.apache.jena.tdb2.store.nodetable.NodeTableInline;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTableConcrete;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.store.tupletable.TupleIndexRecord;
import org.slf4j.Logger;

public abstract class AbstractTDBBuilder {
    final Location location;
    final StoreParams params;
    final ComponentIdMgr componentIdMgr;
    final TransactionCoordinator txnCoord;
    protected static FileFilter fileFilterNewDB = pathname -> {
        String fn = pathname.getName();
        if (fn.equals(".") || fn.equals("..")) {
            return false;
        }
        if (pathname.isDirectory()) {
            return true;
        }
        if (fn.equals("tdb.lock")) {
            return false;
        }
        return !fn.equals("tdb.cfg");
    };

    protected abstract Logger log();

    public static TransactionCoordinator buildTransactionCoordinator(Location location) {
        Journal journal = Journal.create((Location)location);
        TransactionCoordinator txnCoord = new TransactionCoordinator(journal);
        return txnCoord;
    }

    public static String choosePrimaryForIndex(StoreParams params, String index) {
        String primary3 = params.getPrimaryIndexTriples();
        String primary4 = params.getPrimaryIndexQuads();
        if (index.length() == primary3.length()) {
            return primary3;
        }
        if (index.length() == primary4.length()) {
            return primary4;
        }
        throw new DBOpEnvException("Can't find primary for '" + index + "'");
    }

    protected AbstractTDBBuilder(TransactionCoordinator txnCoord, Location location, StoreParams params, ComponentIdMgr componentIdMgr) {
        this.txnCoord = txnCoord;
        this.location = location;
        this.params = params;
        this.componentIdMgr = componentIdMgr;
    }

    public abstract NodeTable buildBaseNodeTable(String var1);

    public abstract RangeIndex buildRangeIndex(RecordFactory var1, String var2);

    protected DatasetGraphTxn build$() {
        NodeTable nodeTable = this.buildNodeTable(this.params.getNodeTableBaseName());
        TripleTable tripleTable = this.buildTripleTable(nodeTable);
        QuadTable quadTable = this.buildQuadTable(nodeTable);
        NodeTable nodeTablePrefixes = this.buildNodeTable(this.params.getPrefixTableBaseName());
        DatasetPrefixesTDB prefixes = this.buildPrefixTable(nodeTablePrefixes);
        TransactionalBase trans = new TransactionalBase(this.txnCoord);
        DatasetGraphTDB dsg = new DatasetGraphTDB((TransactionalSystem)trans, tripleTable, quadTable, prefixes, ReorderLib.fixed(), this.location, this.params);
        QC.setFactory((Context)dsg.getContext(), (OpExecutorFactory)OpExecutorTDB1.OpExecFactoryTDB);
        this.txnCoord.start();
        return dsg;
    }

    public Location getLocation() {
        return this.location;
    }

    public StoreParams getParams() {
        return this.params;
    }

    public TransactionCoordinator getTxnCoord() {
        return this.txnCoord;
    }

    protected static boolean isNewDatabaseArea(Location location) {
        if (location.isMem()) {
            return true;
        }
        File d = new File(location.getDirectoryPath());
        if (!d.exists()) {
            return true;
        }
        FileFilter ff = fileFilterNewDB;
        File[] entries = d.listFiles(ff);
        return entries.length == 0;
    }

    public TripleTable buildTripleTable(NodeTable nodeTable) {
        String primary = this.params.getPrimaryIndexTriples();
        CharSequence[] indexes = this.params.getTripleIndexes();
        if (indexes.length != 3 && indexes.length != 2) {
            this.error(this.log(), "Wrong number of triple table indexes: " + String.join((CharSequence)",", indexes));
        }
        this.log().debug("Triple table: " + primary + " :: " + String.join((CharSequence)",", indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(primary, (String[])indexes);
        if (tripleIndexes.length != indexes.length) {
            this.error(this.log(), "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable);
        return tripleTable;
    }

    public QuadTable buildQuadTable(NodeTable nodeTable) {
        String primary = this.params.getPrimaryIndexQuads();
        CharSequence[] indexes = this.params.getQuadIndexes();
        if (indexes.length != 6 && indexes.length != 4) {
            this.error(this.log(), "Wrong number of quad table indexes: " + String.join((CharSequence)",", indexes));
        }
        this.log().debug("Quad table: " + primary + " :: " + String.join((CharSequence)",", indexes));
        TupleIndex[] quadIndexes = this.makeTupleIndexes(primary, (String[])indexes);
        if (quadIndexes.length != indexes.length) {
            this.error(this.log(), "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable);
        return quadTable;
    }

    public DatasetPrefixesTDB buildPrefixTable(NodeTable prefixNodes) {
        CharSequence[] indexes;
        String primary = this.params.getPrimaryIndexPrefix();
        TupleIndex[] prefixIndexes = this.makeTupleIndexes(primary, (String[])(indexes = this.params.getPrefixIndexes()));
        if (prefixIndexes.length != 1) {
            this.error(this.log(), "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        NodeTupleTableConcrete prefixTable = new NodeTupleTableConcrete(primary.length(), prefixIndexes, prefixNodes);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixTable);
        this.log().debug("Prefixes: " + primary + " :: " + String.join((CharSequence)",", indexes));
        return prefixes;
    }

    public TupleIndex[] makeTupleIndexes(String primary, String[] indexNames) {
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[indexNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            String indexName = indexNames[i];
            String indexLabel = indexNames[i];
            indexes[i] = this.buildTupleIndex(primary, indexName, indexLabel);
        }
        return indexes;
    }

    public TupleIndex buildTupleIndex(String primary, String index, String name) {
        TupleMap cmap = TupleMap.create((String)primary, (String)index);
        RecordFactory rf = new RecordFactory(8 * cmap.length(), 0);
        RangeIndex rIdx = this.buildRangeIndex(rf, index);
        TupleIndexRecord tIdx = new TupleIndexRecord(primary.length(), cmap, index, rf, rIdx);
        return tIdx;
    }

    public NodeTable buildNodeTable(String name) {
        NodeTable nodeTable = this.buildBaseNodeTable(name);
        nodeTable = NodeTableCache.create(nodeTable, this.params);
        nodeTable = NodeTableInline.create(nodeTable);
        return nodeTable;
    }

    public TransBinaryDataFile buildBinaryDataFile(String name) {
        ComponentId cid = this.componentIdMgr.getComponentId(name);
        FileSet fs = new FileSet(this.location, name);
        BinaryDataFile binFile = FileFactory.createBinaryDataFile((FileSet)fs, (String)"obj");
        BufferChannel pState = FileFactory.createBufferChannel((FileSet)fs, (String)"bdf");
        TransBinaryDataFile transBinFile = new TransBinaryDataFile(binFile, cid, pState);
        return transBinFile;
    }

    private void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }
}

