/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.setup;

import java.util.UUID;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.apache.jena.dboe.trans.data.TransBinaryDataFile;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.tdb2.setup.AbstractTDBBuilder;
import org.apache.jena.tdb2.setup.ComponentIdMgr;
import org.apache.jena.tdb2.setup.StoreParams;
import org.apache.jena.tdb2.setup.StoreParamsCodec;
import org.apache.jena.tdb2.setup.StoreParamsFactory;
import org.apache.jena.tdb2.store.DatasetGraphTxn;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableTRDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDBBuilder
extends AbstractTDBBuilder {
    private Logger log = LoggerFactory.getLogger(TDBBuilder.class);

    @Override
    protected Logger log() {
        return this.log;
    }

    public static DatasetGraphTxn build(Location location) {
        return TDBBuilder.build(location, StoreParams.getDftStoreParams());
    }

    public static DatasetGraphTxn build(Location location, StoreParams appParams) {
        StoreParams locParams = StoreParamsCodec.read(location);
        StoreParams dftParams = StoreParams.getDftStoreParams();
        boolean newArea = TDBBuilder.isNewDatabaseArea(location);
        if (newArea) {
            // empty if block
        }
        StoreParams params = StoreParamsFactory.decideStoreParams(location, newArea, appParams, locParams, dftParams);
        return TDBBuilder.create(location, params).build$();
    }

    public static TDBBuilder create(Location location) {
        return TDBBuilder.create(location, StoreParams.getDftStoreParams());
    }

    public static TDBBuilder create(Location location, StoreParams params) {
        TransactionCoordinator txnCoord = TDBBuilder.buildTransactionCoordinator(location);
        return new TDBBuilder(txnCoord, location, params, new ComponentIdMgr(UUID.randomUUID()));
    }

    public static TDBBuilder create(TransactionCoordinator txnCoord, Location location, StoreParams params) {
        return new TDBBuilder(txnCoord, location, params, new ComponentIdMgr(UUID.randomUUID()));
    }

    protected TDBBuilder(TransactionCoordinator txnCoord, Location location, StoreParams params, ComponentIdMgr componentIdMgr) {
        super(txnCoord, location, params, componentIdMgr);
    }

    @Override
    public RangeIndex buildRangeIndex(RecordFactory recordFactory, String name) {
        ComponentId cid = this.componentIdMgr.getComponentId(name);
        FileSet fs = new FileSet(this.location, name);
        BPlusTree bpt = BPlusTreeFactory.createBPTree((ComponentId)cid, (FileSet)fs, (RecordFactory)recordFactory);
        this.txnCoord.add((TransactionalComponent)bpt);
        return bpt;
    }

    @Override
    public NodeTable buildBaseNodeTable(String name) {
        RecordFactory recordFactory = new RecordFactory(16, 8);
        RangeIndex index = this.buildRangeIndex(recordFactory, name);
        String dataname = name + "-data";
        TransBinaryDataFile transBinFile = this.buildBinaryDataFile(dataname);
        this.txnCoord.add((TransactionalComponent)transBinFile);
        return new NodeTableTRDF((Index)index, (BinaryDataFile)transBinFile);
    }
}

