local base_dir = "LUABoneSystem/base/"
local custom_dir = "LUABoneSystem/custom/"
local base_position_list = {[0] = json.load_file(base_dir .. "m_shadow.json"), [1] = json.load_file(base_dir .. "f_shadow.json")}
local shadowmesh_data = {[0] = {["equipments"] = {}, ["offset"] = {}}, [1] = {["equipments"] = {}, ["offset"] = {}}}
local parts = {"helm", "body", "arm", "wst", "leg"}
local old_players_parts = {}
local enable = true
local init = {[0] = false, [1] = false}
local export_file_name
local import_file_name
local settings = json.load_file(base_dir .. "settings.json")
local import_joint_data = {}
local import_part_data = {}
local player_joint = {}

if settings ~= nil then
	for _, file_name in pairs(settings) do
		local import_data = json.load_file(custom_dir .. file_name .. ".json")
		if import_data ~= nil then
			import_joint_data[file_name] = import_data
			for _, part_name in pairs(import_data["equipments"]) do
				import_part_data[part_name] = file_name
			end
		end
	end
end

re.on_draw_ui(function()
	if imgui.tree_node("LUA Bone System") then
		local changed
		changed, enable = imgui.checkbox("Enable", enable)
		if not export_file_name then
			export_file_name = "file name(no name extension)"
		end
		changed, export_file_name = imgui.input_text("1", export_file_name)
		imgui.same_line()
		if imgui.button("Export") then
			local playerManager = sdk.get_managed_singleton("snow.player.PlayerManager")
			if playerManager == nil then
				return
			end
			local master_player = playerManager:call("findMasterPlayer()")
			if master_player == nil then
				return
			end
			local master_player_sex = master_player:get_field("mSex")
			local master_player_index = master_player:call("getPlayerIndex")
			local master_player_parts = old_players_parts[master_player_index]
			shadowmesh_data[master_player_sex]["equipments"] = {}
			for part_name, part_obj in pairs(master_player_parts) do
				table.insert(shadowmesh_data[master_player_sex]["equipments"], part_obj:call("get_Name"))
			end
			json.dump_file(custom_dir .. export_file_name .. ".json", shadowmesh_data[master_player_sex])
		end
		if not import_file_name then
			import_file_name = "file name(no name extension)"
		end
		changed, import_file_name = imgui.input_text("2", import_file_name)
		imgui.same_line()
		if imgui.button("Import") then
			local import_data = json.load_file(custom_dir .. import_file_name .. ".json")
			if import_data ~= nil then
				if settings == nil then
					settings = {}
				end
				local exists = false
				for _, file_name in pairs(settings) do
					if file_name == import_file_name then
						exists = true
						break
					end
				end
				if exists == false then
					table.insert(settings, import_file_name)
					json.dump_file(base_dir .. "settings.json", settings)
				end
				import_joint_data[import_file_name] = import_data
				for _, part_name in pairs(import_data["equipments"]) do
					import_part_data[part_name] = import_file_name
				end
			end
		end
		for part_name, file_name in pairs(import_part_data) do
			imgui.text(part_name)
			imgui.same_line()
			imgui.indent(120)
			imgui.text(file_name .. ".json")
			imgui.unindent(120)
		end
	end
end)

re.on_pre_application_entry("PrepareRendering", function()
	local playerManager = sdk.get_managed_singleton("snow.player.PlayerManager")
	if playerManager == nil then
		return
	end
	local player_list = playerManager:get_field("PlayerList")
	if player_list == nil then
		return
	end
	for i, player in pairs(player_list) do
		if player == nil then
			goto continue
		end
		local player_obj
		local status, err = pcall(function() player_obj = player:call("get_GameObject") end)
		if player_obj == nil then
			goto continue
		end
		local player_transform = player_obj:call("get_Transform")
		if player_transform == nil or player_transform:get_reference_count() == 1 then
			goto continue
		end
		local joint_list = player_transform:get_Joints()
		local player_sex = player:get_field("mSex")
		if init[player_sex] == false then
			for _, joint in pairs(joint_list) do
				local joint_name = joint:get_Name()
				local custom_position = joint:call("get_BaseLocalPosition")
				local base_position = base_position_list[player_sex][joint_name]
				local total_offset = {}
				total_offset["x"] = custom_position.x - base_position["x"]
				total_offset["y"] = custom_position.y - base_position["y"]
				total_offset["z"] = custom_position.z - base_position["z"]
				shadowmesh_data[player_sex]["offset"][joint_name] = total_offset
			end
			init[player_sex] = true
		end
		local player_index = player:call("getPlayerIndex")
		local player_parts = {}
		local child = player_transform:call("get_Child")
		while child do
			local childObject = child:call("get_GameObject")
			local childObjectName = childObject:call("get_Name")
			for _, part_name in pairs(parts) do
				if string.find(childObjectName, part_name) then
					player_parts[part_name] = childObject
					break
				end
			end
			child = child:call("get_Next")
		end
		old_players_parts[player_index] = player_parts
		for part_name, part_obj in pairs(player_parts) do
			if import_part_data[part_obj:get_Name()] ~= nil then
				player_joint[player_index] = import_part_data[part_obj:get_Name()]
				break
			else
				player_joint[player_index] = nil
			end
		end
		::continue::
	end
	if not enable then
		return
	end
	local timeManager = sdk.get_managed_singleton("snow.TimeScaleManager")
	if timeManager == nil then
		return
	end
	local isPaused = timeManager:get__Pausing()
	if isPaused then
		return
	end
	for i, player in pairs(player_list) do
		if player == nil then
			goto continue2
		end
		local player_obj
		local status, err = pcall(function() player_obj = player:call("get_GameObject") end)
		if player_obj == nil then
			goto continue2
		end
		local player_transform = player_obj:call("get_Transform")
		if player_transform == nil or player_transform:get_reference_count() == 1 then
			goto continue2
		end
		local joint_list = player_transform:get_Joints()
		local player_index = player:call("getPlayerIndex")
		local player_sex = player:get_field("mSex")
		if player_joint[player_index] == nil then
			for i, joint in pairs(joint_list) do
				local posOffset = shadowmesh_data[player_sex]["offset"][joint:get_Name()]
				if posOffset ~= nil then 
					local offsetB = joint:get_LocalPosition()
					local offsetF = Vector3f.new( offsetB.x - posOffset["x"] ,offsetB.y - posOffset["y"] ,offsetB.z - posOffset["z"])
					joint:call("set_LocalPosition", offsetF)
				end
			end
		else
			for i, joint in pairs(joint_list) do
				local posOffset = shadowmesh_data[player_sex]["offset"][joint:get_Name()]
				local newOffset = import_joint_data[player_joint[player_index]]["offset"][joint:get_Name()]
				if posOffset ~= nil then 
					local offsetB = joint:get_LocalPosition()
					local offsetF = Vector3f.new( offsetB.x - posOffset["x"] + newOffset["x"] ,offsetB.y - posOffset["y"] + newOffset["y"] ,offsetB.z - posOffset["z"] + newOffset["z"])
					joint:call("set_LocalPosition", offsetF)
				end
			end
		end
		::continue2::
	end
end)
