/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;

public class RandomMobs {
    private static Map locationProperties = new HashMap();
    private static bno renderGlobal = null;
    private static boolean initialized = false;
    private static Random random = new Random();
    private static boolean working = false;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_MCPATCHER_MOB = "mcpatcher/mob/";
    private static final String[] DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};

    public static void entityLoaded(rr entity, aht world) {
        int id;
        if (!(entity instanceof sb)) {
            return;
        }
        if (world == null) {
            return;
        }
        sb el = (sb)entity;
        el.spawnPosition = el.c();
        el.spawnBiome = world.b(el.spawnPosition);
        lp ws = Config.getWorldServer();
        if (ws == null) {
            return;
        }
        rr es = ws.a(entity.O());
        if (!(es instanceof sb)) {
            return;
        }
        sb els = (sb)es;
        UUID uuid = els.bc();
        long uuidLow = uuid.getLeastSignificantBits();
        el.randomMobsId = id = (int)(uuidLow & Integer.MAX_VALUE);
    }

    public static void worldChanged(aht oldWorld, aht newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.J();
            for (int e = 0; e < entityList.size(); ++e) {
                rr entity = (rr)entityList.get(e);
                RandomMobs.entityLoaded(entity, newWorld);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static kk getTextureLocation(kk loc) {
        if (working) {
            return loc;
        }
        try {
            working = true;
            if (!initialized) {
                RandomMobs.initialize();
            }
            if (renderGlobal == null) {
                kk kk2 = loc;
                return kk2;
            }
            rr entity = RandomMobs.renderGlobal.renderedEntity;
            if (!(entity instanceof sb)) {
                kk kk3 = loc;
                return kk3;
            }
            sb entityLiving = (sb)entity;
            String name = loc.a();
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY)) {
                kk kk4 = loc;
                return kk4;
            }
            RandomMobsProperties props = RandomMobs.getProperties(loc);
            if (props == null) {
                kk kk5 = loc;
                return kk5;
            }
            kk kk6 = props.getTextureLocation(loc, entityLiving);
            return kk6;
        }
        finally {
            working = false;
        }
    }

    private static RandomMobsProperties getProperties(kk loc) {
        String name = loc.a();
        RandomMobsProperties props = (RandomMobsProperties)locationProperties.get(name);
        if (props == null) {
            props = RandomMobs.makeProperties(loc);
            locationProperties.put(name, props);
        }
        return props;
    }

    private static RandomMobsProperties makeProperties(kk loc) {
        RandomMobsProperties props;
        String path = loc.a();
        kk propLoc = RandomMobs.getPropertyLocation(loc);
        if (propLoc != null && (props = RandomMobs.parseProperties(propLoc, loc)) != null) {
            return props;
        }
        kk[] variants = RandomMobs.getTextureVariants(loc);
        return new RandomMobsProperties(path, variants);
    }

    private static RandomMobsProperties parseProperties(kk propLoc, kk resLoc) {
        try {
            String path = propLoc.a();
            Config.dbg("RandomMobs: " + resLoc.a() + ", variants: " + path);
            InputStream in = Config.getResourceStream(propLoc);
            if (in == null) {
                Config.warn("RandomMobs properties not found: " + path);
                return null;
            }
            Properties props = new Properties();
            props.load(in);
            in.close();
            RandomMobsProperties rmp = new RandomMobsProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e) {
            Config.warn("RandomMobs file not found: " + resLoc.a());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static kk getPropertyLocation(kk loc) {
        String pathProps;
        kk locProps;
        kk locMcp = RandomMobs.getMcpatcherLocation(loc);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        String path = locMcp.a();
        String pathBase = path;
        if (pathBase.endsWith(SUFFIX_PNG)) {
            pathBase = pathBase.substring(0, pathBase.length() - SUFFIX_PNG.length());
        }
        if (Config.hasResource(locProps = new kk(domain, pathProps = pathBase + SUFFIX_PROPERTIES))) {
            return locProps;
        }
        String pathParent = RandomMobs.getParentPath(pathBase);
        if (pathParent == null) {
            return null;
        }
        kk locParentProps = new kk(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    public static kk getMcpatcherLocation(kk loc) {
        String path = loc.a();
        if (!path.startsWith(PREFIX_TEXTURES_ENTITY)) {
            return null;
        }
        String pathMcp = PREFIX_MCPATCHER_MOB + path.substring(PREFIX_TEXTURES_ENTITY.length());
        return new kk(loc.b(), pathMcp);
    }

    public static kk getLocationIndexed(kk loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        kk locNew = new kk(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentPath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = path.substring(0, path.length() - suffix.length());
            return pathParent;
        }
        return null;
    }

    private static kk[] getTextureVariants(kk loc) {
        ArrayList<kk> list = new ArrayList<kk>();
        list.add(loc);
        kk locMcp = RandomMobs.getMcpatcherLocation(loc);
        if (locMcp == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            kk locIndex = RandomMobs.getLocationIndexed(locMcp, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        kk[] locs = list.toArray(new kk[list.size()]);
        Config.dbg("RandomMobs: " + loc.a() + ", variants: " + locs.length);
        return locs;
    }

    public static void resetTextures() {
        locationProperties.clear();
        if (Config.isRandomMobs()) {
            RandomMobs.initialize();
        }
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        if (renderGlobal == null) {
            return;
        }
        initialized = true;
        ArrayList<String> list = new ArrayList<String>();
        list.add("bat");
        list.add("blaze");
        list.add("cat/black");
        list.add("cat/ocelot");
        list.add("cat/red");
        list.add("cat/siamese");
        list.add("chicken");
        list.add("cow/cow");
        list.add("cow/mooshroom");
        list.add("creeper/creeper");
        list.add("enderman/enderman");
        list.add("enderman/enderman_eyes");
        list.add("ghast/ghast");
        list.add("ghast/ghast_shooting");
        list.add("iron_golem");
        list.add("pig/pig");
        list.add("sheep/sheep");
        list.add("sheep/sheep_fur");
        list.add("silverfish");
        list.add("skeleton/skeleton");
        list.add("skeleton/wither_skeleton");
        list.add("slime/slime");
        list.add("slime/magmacube");
        list.add("snowman");
        list.add("spider/cave_spider");
        list.add("spider/spider");
        list.add("spider_eyes");
        list.add("squid");
        list.add("villager/villager");
        list.add("villager/butcher");
        list.add("villager/farmer");
        list.add("villager/librarian");
        list.add("villager/priest");
        list.add("villager/smith");
        list.add("wither/wither");
        list.add("wither/wither_armor");
        list.add("wither/wither_invulnerable");
        list.add("wolf/wolf");
        list.add("wolf/wolf_angry");
        list.add("wolf/wolf_collar");
        list.add("wolf/wolf_tame");
        list.add("zombie_pigman");
        list.add("zombie/zombie");
        list.add("zombie/zombie_villager");
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            String tex = PREFIX_TEXTURES_ENTITY + name + SUFFIX_PNG;
            kk texLoc = new kk(tex);
            if (!Config.hasResource(texLoc)) {
                Config.warn("Not found: " + texLoc);
            }
            RandomMobs.getProperties(texLoc);
        }
    }
}

