<?php

/**
 * BaseEmployeeTerminationRecord
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                        $id                                          Type: integer(4), primary key
 * @property int                        $empNumber                                   Type: integer(4)
 * @property int                        $reasonId                                    Type: integer(4)
 * @property string                     $date                                        Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                     $note                                        Type: string(255)
 * @property TerminationReason          $TerminationReason                           
 * @property Employee                   $Employee                                    
 *  
 * @method int                          getId()                                      Type: integer(4), primary key
 * @method int                          getEmpnumber()                               Type: integer(4)
 * @method int                          getReasonid()                                Type: integer(4)
 * @method string                       getDate()                                    Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                       getNote()                                    Type: string(255)
 * @method TerminationReason            getTerminationReason()                       
 * @method Employee                     getEmployee()                                
 *  
 * @method EmployeeTerminationRecord    setId(int $val)                              Type: integer(4), primary key
 * @method EmployeeTerminationRecord    setEmpnumber(int $val)                       Type: integer(4)
 * @method EmployeeTerminationRecord    setReasonid(int $val)                        Type: integer(4)
 * @method EmployeeTerminationRecord    setDate(string $val)                         Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method EmployeeTerminationRecord    setNote(string $val)                         Type: string(255)
 * @method EmployeeTerminationRecord    setTerminationReason(TerminationReason $val) 
 * @method EmployeeTerminationRecord    setEmployee(Employee $val)                   
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployeeTerminationRecord extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_emp_termination');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('emp_number as empNumber', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('reason_id as reasonId', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
        $this->hasColumn('termination_date as date', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
        $this->hasColumn('note', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('TerminationReason', array(
             'local' => 'reasonId',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'id',
             'foreign' => 'termination_id'));
    }
}