/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JTable;
import pl.mpak.orbada.export.ExportToClipboardDialog;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToClipboard
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    public static final int RANGE_CURRENT = 0;
    public static final int RANGE_ALL = 1;
    private static ISettings config;
    private boolean fullEOL;
    private String separator;
    private int columnRange;
    private int rowRange;
    private boolean includeTitles;
    private boolean removeSeparator;
    private String charset;
    private boolean horizontal;
    private boolean decSepGlobSettings;
    private Variant valueGlobSet;

    public ExportToClipboard() {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.getDefault()));
        format.setMaximumFractionDigits(Variant.getDefaultNumberFormatMaximumFractionDigits());
        format.setGroupingUsed(false);
        this.valueGlobSet = new Variant(format);
        this.setShortCut(67, 3);
        this.setText(this.stringManager.getString("ExportToClipboard-text"));
        this.setActionCommandKey("ExportToClipboard");
        this.addActionListener(this.createActionListener());
    }

    private ISettings getConfig() {
        if (config == null) {
            config = this.application.getSettings("export-to-clipboard");
        }
        return config;
    }

    private String newLine() {
        if (this.fullEOL) {
            return "\r\n";
        }
        return "\n";
    }

    private String separator() {
        if ("TAB".equals(this.separator)) {
            return "\t";
        }
        if ("ENTER".equals(this.separator)) {
            return "\n";
        }
        return this.separator;
    }

    private void exportRow(StringBuilder sb, JTable table, int row) {
        if (this.columnRange == 0 && table.getSelectedColumn() != -1) {
            this.append(sb, table.getValueAt(row, table.getSelectedColumn()));
        } else {
            for (int c = 0; c < table.getColumnCount(); ++c) {
                this.append(sb, table.getValueAt(row, c));
                if (c >= table.getColumnCount() - 1) continue;
                sb.append(this.separator());
            }
        }
    }

    private void append(StringBuilder sb, Object str) {
        if (str != null) {
            String s;
            block10: {
                if (str instanceof Variant) {
                    try {
                        if (this.decSepGlobSettings) {
                            this.valueGlobSet.setValue(((Variant)str).getValue());
                            s = this.valueGlobSet.toString();
                            break block10;
                        }
                        s = ((Variant)str).getString();
                    }
                    catch (Exception ex) {
                        s = "";
                    }
                } else {
                    s = str.toString();
                }
            }
            if (this.removeSeparator) {
                s = s.replace(this.separator(), "");
            }
            if (!"".equals(this.charset)) {
                try {
                    s = new String(s.getBytes(), this.charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            sb.append(s);
        }
    }

    private void localConfig() {
        try {
            this.fullEOL = this.getConfig().getValue("full-eol").getBoolean();
            this.separator = this.getConfig().getValue("separator").getString();
            this.columnRange = this.getConfig().getValue("column-range").getInteger();
            this.rowRange = this.getConfig().getValue("row-range").getInteger();
            this.includeTitles = this.getConfig().getValue("include-titles").getBoolean();
            this.removeSeparator = this.getConfig().getValue("remove-separator").getBoolean();
            this.charset = this.getConfig().getValue("charset").getString();
            this.horizontal = this.getConfig().getValue("horizontal").getBoolean();
            this.decSepGlobSettings = this.getConfig().getValue("dec-sep-glob-settings").getBoolean();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToClipboard.this.getTable(event);
                if (table != null && ExportToClipboardDialog.showDialog(ExportToClipboard.this.getConfig())) {
                    ExportToClipboard.this.localConfig();
                    StringBuilder sb = new StringBuilder();
                    if (ExportToClipboard.this.includeTitles) {
                        if (ExportToClipboard.this.columnRange == 0 && table.getSelectedColumn() != -1) {
                            sb.append(table.getColumnModel().getColumn(table.getSelectedColumn()).getHeaderValue().toString());
                        } else {
                            for (int c = 0; c < table.getColumnCount(); ++c) {
                                sb.append(table.getColumnModel().getColumn(c).getHeaderValue().toString() + (c < table.getColumnCount() - 1 ? ExportToClipboard.this.separator() : ""));
                            }
                        }
                        if (ExportToClipboard.this.columnRange == 0 && ExportToClipboard.this.horizontal) {
                            sb.append(ExportToClipboard.this.separator());
                        } else {
                            sb.append(ExportToClipboard.this.newLine());
                        }
                    }
                    if (ExportToClipboard.this.rowRange == 0 && table.getSelectedRow() != -1) {
                        ExportToClipboard.this.exportRow(sb, table, table.getSelectedRow());
                    } else {
                        for (int r = 0; r < table.getRowCount(); ++r) {
                            ExportToClipboard.this.exportRow(sb, table, r);
                            if (ExportToClipboard.this.columnRange == 0 && ExportToClipboard.this.horizontal && r < table.getRowCount() - 1) {
                                sb.append(ExportToClipboard.this.separator());
                                continue;
                            }
                            sb.append(ExportToClipboard.this.newLine());
                        }
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection data = new StringSelection(sb.toString());
                    clipboard.setContents(data, data);
                }
            }
        };
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToClipboard-description");
    }

    public String getGroupName() {
        return "Export tools";
    }
}

