/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToClipboardDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkFullEOL;
    private JCheckBox checkGlobalSettings;
    private JCheckBox checkHorizontal;
    private JCheckBox checkIncludeTitles;
    private JCheckBox checkRemoveSeparator;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboCharSet;
    private JComboBox comboSeparator;
    private ButtonGroup groupColumnRange;
    private ButtonGroup groupRowRange;
    private JLabel label1;
    private JLabel label2;
    private JPanel panelColumnRange;
    private JPanel panelDecimalSeparator;
    private JPanel panelRowRange;
    private JPanel panelSeparator;
    private JRadioButton radioAllColumns;
    private JRadioButton radioAllRows;
    private JRadioButton radioCurrentColumn;
    private JRadioButton radioCurrentRow;

    public ExportToClipboardDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
    }

    public static boolean showDialog(ISettings config) {
        ExportToClipboardDialog dialog = new ExportToClipboardDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharSet.addItem(charset.displayName());
        }
    }

    private void configToDialog() {
        try {
            this.radioCurrentRow.setSelected(this.config.getValue("row-range", new Variant(1)).getInteger() == 0);
            this.radioAllRows.setSelected(this.config.getValue("row-range", new Variant(1)).getInteger() == 1);
            this.radioCurrentColumn.setSelected(this.config.getValue("column-range", new Variant(1)).getInteger() == 0);
            this.radioAllColumns.setSelected(this.config.getValue("column-range", new Variant(1)).getInteger() == 1);
            this.comboSeparator.setSelectedItem(this.config.getValue("separator", new Variant("TAB")).getString());
            this.checkRemoveSeparator.setSelected(this.config.getValue("remove-separator", new Variant(true)).getBoolean());
            this.checkFullEOL.setSelected(this.config.getValue("full-eol", new Variant(false)).getBoolean());
            this.checkIncludeTitles.setSelected(this.config.getValue("include-titles", new Variant(true)).getBoolean());
            this.comboCharSet.setSelectedItem(this.config.getValue("charset", new Variant(Charset.defaultCharset().displayName())).getString());
            this.checkHorizontal.setSelected(this.config.getValue("horizontal", new Variant(false)).getBoolean());
            this.checkGlobalSettings.setSelected(this.config.getValue("dec-sep-glob-settings").getBoolean());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig() {
        if (this.radioCurrentRow.isSelected()) {
            this.config.setValue("row-range", new Variant(0));
        }
        if (this.radioAllRows.isSelected()) {
            this.config.setValue("row-range", new Variant(1));
        }
        if (this.radioCurrentColumn.isSelected()) {
            this.config.setValue("column-range", new Variant(0));
        }
        if (this.radioAllColumns.isSelected()) {
            this.config.setValue("column-range", new Variant(1));
        }
        this.config.setValue("separator", new Variant(this.comboSeparator.getSelectedItem().toString()));
        this.config.setValue("remove-separator", new Variant(this.checkRemoveSeparator.isSelected()));
        this.config.setValue("full-eol", new Variant(this.checkFullEOL.isSelected()));
        this.config.setValue("include-titles", new Variant(this.checkIncludeTitles.isSelected()));
        this.config.setValue("charset", new Variant(this.comboCharSet.getSelectedItem().toString()));
        this.config.setValue("horizontal", new Variant(this.checkHorizontal.isSelected()));
        this.config.setValue("dec-sep-glob-settings", new Variant(this.checkGlobalSettings.isSelected()));
        this.config.store();
    }

    private void initComponents() {
        this.groupRowRange = new ButtonGroup();
        this.groupColumnRange = new ButtonGroup();
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.panelRowRange = new JPanel();
        this.radioCurrentRow = new JRadioButton();
        this.radioAllRows = new JRadioButton();
        this.panelColumnRange = new JPanel();
        this.radioCurrentColumn = new JRadioButton();
        this.radioAllColumns = new JRadioButton();
        this.checkHorizontal = new JCheckBox();
        this.panelSeparator = new JPanel();
        this.label1 = new JLabel();
        this.comboSeparator = new JComboBox();
        this.checkRemoveSeparator = new JCheckBox();
        this.checkFullEOL = new JCheckBox();
        this.checkIncludeTitles = new JCheckBox();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.label2 = new JLabel();
        this.comboCharSet = new JComboBox();
        this.panelDecimalSeparator = new JPanel();
        this.checkGlobalSettings = new JCheckBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToClipboardDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToClipboardDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("pl/mpak/orbada/export/i18n");
        this.setTitle(bundle.getString("ExportToClipboardDialog-title"));
        this.setModal(true);
        this.panelRowRange.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("ExportToClipboardDialog-groupRows-border-title")));
        this.groupRowRange.add(this.radioCurrentRow);
        this.radioCurrentRow.setText(this.stringManager.getString("ExportToClipboardDialog-radioCurrentRow-text"));
        this.groupRowRange.add(this.radioAllRows);
        this.radioAllRows.setSelected(true);
        this.radioAllRows.setText(this.stringManager.getString("ExportToClipboardDialog-radioAllRows-text"));
        GroupLayout panelRowRangeLayout = new GroupLayout(this.panelRowRange);
        this.panelRowRange.setLayout(panelRowRangeLayout);
        panelRowRangeLayout.setHorizontalGroup(panelRowRangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRowRangeLayout.createSequentialGroup().addContainerGap().addGroup(panelRowRangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioCurrentRow, GroupLayout.Alignment.TRAILING, -1, 288, Short.MAX_VALUE).addComponent(this.radioAllRows, -1, 288, Short.MAX_VALUE)).addContainerGap()));
        panelRowRangeLayout.setVerticalGroup(panelRowRangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRowRangeLayout.createSequentialGroup().addComponent(this.radioCurrentRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioAllRows)));
        this.panelColumnRange.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("ExportToClipboardDialog-groupColumns-border-title")));
        this.groupColumnRange.add(this.radioCurrentColumn);
        this.radioCurrentColumn.setText(this.stringManager.getString("ExportToClipboardDialog-radioCurrentColumn-text"));
        this.radioCurrentColumn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ExportToClipboardDialog.this.radioCurrentColumnStateChanged(evt);
            }
        });
        this.groupColumnRange.add(this.radioAllColumns);
        this.radioAllColumns.setSelected(true);
        this.radioAllColumns.setText(this.stringManager.getString("ExportToClipboardDialog-radioAllColumns-text"));
        this.checkHorizontal.setText(this.stringManager.getString("ExportToClipboardDialog-checkHorizontal-text"));
        this.checkHorizontal.setToolTipText(this.stringManager.getString("ExportToClipboardDialog-checkHorizontal-hint"));
        this.checkHorizontal.setEnabled(false);
        GroupLayout panelColumnRangeLayout = new GroupLayout(this.panelColumnRange);
        this.panelColumnRange.setLayout(panelColumnRangeLayout);
        panelColumnRangeLayout.setHorizontalGroup(panelColumnRangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelColumnRangeLayout.createSequentialGroup().addContainerGap().addGroup(panelColumnRangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelColumnRangeLayout.createSequentialGroup().addComponent(this.radioCurrentColumn, -1, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkHorizontal)).addComponent(this.radioAllColumns, -1, 288, Short.MAX_VALUE)).addContainerGap()));
        panelColumnRangeLayout.setVerticalGroup(panelColumnRangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelColumnRangeLayout.createSequentialGroup().addGroup(panelColumnRangeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkHorizontal).addComponent(this.radioCurrentColumn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioAllColumns).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelSeparator.setBorder(BorderFactory.createTitledBorder(bundle.getString("ExportToClipboardDialog-groupSeparator-border-title")));
        this.label1.setHorizontalAlignment(4);
        this.label1.setText(this.stringManager.getString("ExportToClipboardDialog-separator-dd"));
        this.comboSeparator.setEditable(true);
        this.comboSeparator.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "TAB", ";", ","}));
        this.comboSeparator.setSelectedIndex(1);
        this.checkRemoveSeparator.setSelected(true);
        this.checkRemoveSeparator.setText(this.stringManager.getString("ExportToClipboardDialog-checkRemoveSeparator-text"));
        GroupLayout panelSeparatorLayout = new GroupLayout(this.panelSeparator);
        this.panelSeparator.setLayout(panelSeparatorLayout);
        panelSeparatorLayout.setHorizontalGroup(panelSeparatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSeparatorLayout.createSequentialGroup().addContainerGap().addGroup(panelSeparatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkRemoveSeparator, -1, 280, Short.MAX_VALUE).addGroup(panelSeparatorLayout.createSequentialGroup().addComponent(this.label1, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboSeparator, 0, 188, Short.MAX_VALUE))).addContainerGap()));
        panelSeparatorLayout.setVerticalGroup(panelSeparatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSeparatorLayout.createSequentialGroup().addGroup(panelSeparatorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.comboSeparator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkRemoveSeparator).addContainerGap(-1, Short.MAX_VALUE)));
        this.checkFullEOL.setText(this.stringManager.getString("ExportToClipboardDialog-checkFullEOL-text"));
        this.checkIncludeTitles.setSelected(true);
        this.checkIncludeTitles.setText(this.stringManager.getString("ExportToClipboardDialog-checkIncludeTitles-text"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.label2.setHorizontalAlignment(4);
        this.label2.setText(this.stringManager.getString("ExportToClipboardDialog-charcode-dd"));
        this.comboCharSet.setEditable(true);
        this.panelDecimalSeparator.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("ExportToClipboard-DecimalSeparator.title")));
        this.checkGlobalSettings.setText(this.stringManager.getString("ExportToClipboard-DecSep-globalsettings"));
        GroupLayout panelDecimalSeparatorLayout = new GroupLayout(this.panelDecimalSeparator);
        this.panelDecimalSeparator.setLayout(panelDecimalSeparatorLayout);
        panelDecimalSeparatorLayout.setHorizontalGroup(panelDecimalSeparatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDecimalSeparatorLayout.createSequentialGroup().addContainerGap().addComponent(this.checkGlobalSettings, -1, 288, Short.MAX_VALUE).addContainerGap()));
        panelDecimalSeparatorLayout.setVerticalGroup(panelDecimalSeparatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDecimalSeparatorLayout.createSequentialGroup().addComponent(this.checkGlobalSettings).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panelDecimalSeparator, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.checkFullEOL, GroupLayout.Alignment.LEADING, -1, 312, Short.MAX_VALUE).addComponent(this.checkIncludeTitles, GroupLayout.Alignment.LEADING, -1, 312, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.label2, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCharSet, 0, 208, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelRowRange, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.panelColumnRange, -1, -1, Short.MAX_VALUE).addComponent(this.panelSeparator, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelRowRange, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColumnRange, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelDecimalSeparator, -2, -1, -2).addGap(3, 3, 3).addComponent(this.checkFullEOL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkIncludeTitles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent(this.comboCharSet, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void radioCurrentColumnStateChanged(ChangeEvent evt) {
        this.checkHorizontal.setEnabled(this.radioCurrentColumn.isSelected());
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dialogToConfig();
        this.dispose();
    }
}

