/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.JTable;
import pl.mpak.orbada.export.ExportToHtmlDialog;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToHtml
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private String metaCode;
    private String title;
    private String bodyAttrib;
    private String tableCode;
    private String tableAttrib;
    private String tableRowCode;
    private String tableRowAttrib;
    private String tableHeaderCode;
    private String tableHeaderAttrib;
    private String tableDataCode;
    private String tableDataAttrib;
    private String nullDataValue;
    private boolean firstLastAsNbsp;
    private String fileName;
    private boolean includeTitles;
    private String charset;

    public ExportToHtml() {
        this.setText(this.stringManager.getString("ExportToHtml-text"));
        this.setActionCommandKey("ExportToHtml");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToHtml-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-html-file");
    }

    private void localConfig() {
        try {
            this.title = this.getConfig().getValue("title").getString();
            this.metaCode = this.getConfig().getValue("meta-code").getString();
            this.bodyAttrib = this.getConfig().getValue("body-attrib").getString();
            this.tableCode = this.getConfig().getValue("table-code").getString();
            this.tableAttrib = this.getConfig().getValue("table-attrib").getString();
            this.tableRowCode = this.getConfig().getValue("table-row-code").getString();
            this.tableRowAttrib = this.getConfig().getValue("table-row-attrib").getString();
            this.tableHeaderCode = this.getConfig().getValue("table-header-code").getString();
            this.tableHeaderAttrib = this.getConfig().getValue("table-header-attrib").getString();
            this.tableDataCode = this.getConfig().getValue("table-data-code").getString();
            this.tableDataAttrib = this.getConfig().getValue("table-data-attrib").getString();
            this.nullDataValue = this.getConfig().getValue("null-data-value").getString();
            this.firstLastAsNbsp = this.getConfig().getValue("first-last-as-nbsp", Boolean.valueOf(false));
            this.includeTitles = this.getConfig().getValue("include-titles").getBoolean();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void exportHeader(PrintWriter out, JTable table) {
        out.print("<" + this.tableRowCode + " " + this.tableRowAttrib + ">");
        for (int c = 0; c < table.getColumnCount(); ++c) {
            out.print("<" + this.tableHeaderCode + " " + this.tableHeaderAttrib + ">");
            String text = table.getColumnModel().getColumn(c).getHeaderValue().toString();
            if (this.firstLastAsNbsp && !"".equals(text)) {
                if (text.startsWith(" ")) {
                    text = "&nbsp;" + text.substring(1);
                }
                if (text.endsWith(" ")) {
                    text = text.substring(0, text.length() - 1) + "&nbsp;";
                }
            }
            out.print(text);
            out.print("</" + this.tableHeaderCode + ">");
        }
        out.println("</" + this.tableRowCode + ">");
    }

    private void exportRow(PrintWriter out, JTable table, int row) {
        Variant v = new Variant(new DecimalFormat("0.##########"));
        out.println("<" + this.tableRowCode + " " + this.tableRowAttrib + ">");
        for (int c = 0; c < table.getColumnCount(); ++c) {
            out.print("<" + this.tableDataCode + " " + this.tableDataAttrib + ">");
            v.setValue(table.getValueAt(row, c));
            if (v.isNullValue()) {
                out.print(this.nullDataValue);
            } else if (this.firstLastAsNbsp) {
                String text = v.toString();
                if (text.startsWith(" ")) {
                    text = "&nbsp;" + text.substring(1);
                }
                if (text.endsWith(" ")) {
                    text = text.substring(0, text.length() - 1) + "&nbsp;";
                }
                out.print(text);
            } else {
                out.print(v.toString());
            }
            out.print("</" + this.tableDataCode + ">");
        }
        out.println("</" + this.tableRowCode + ">");
    }

    private void exportTable(JTable table) {
        try {
            PrintWriter out = new PrintWriter(new File(this.fileName), this.charset);
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + this.title + "</TITLE>");
            out.println("<META NAME=\"Generator\" CONTENT=\"Orbada Export To Html\" />");
            out.println(String.format("<META HTTP-EQUIV=\"content-type\" CONTENT=\"text/html; charset=%s\" />", this.charset));
            out.println(this.metaCode);
            out.println("</HEAD>");
            out.println("<BODY " + this.bodyAttrib + ">");
            out.println("<" + this.tableCode + " " + this.tableAttrib + ">");
            if (this.includeTitles) {
                this.exportHeader(out, table);
            }
            for (int r = 0; r < table.getRowCount(); ++r) {
                this.exportRow(out, table, r);
            }
            out.println("</" + this.tableCode + ">");
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)"B\u0142\u0105d", (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToHtml.this.getTable(event);
                if (table != null && ExportToHtmlDialog.showDialog(ExportToHtml.this.getConfig())) {
                    ExportToHtml.this.localConfig();
                    ExportToHtml.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

