/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ExportToHtmlDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private DocumentListener changeListener;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkFirstLastAsNbsp;
    private JCheckBox checkIncludeTitles;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboCharset;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel24;
    private JPanel jPanel25;
    private JPanel jPanel26;
    private JPanel jPanel27;
    private JPanel jPanel28;
    private JPanel jPanel29;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JLabel labelEndTableCode;
    private JLabel labelEndTableDataCode;
    private JLabel labelEndTableHeaderCode;
    private JLabel labelEndTableRowCode;
    private TextField textBodyAttrib;
    private TextArea textMetaCode;
    private TextField textNullDataValue;
    private TextField textTableAttrib;
    private TextField textTableCode;
    private TextField textTableDataAttrib;
    private TextField textTableDataCode;
    private TextField textTableHeaderAttrib;
    private TextField textTableHeaderCode;
    private TextField textTableRowAttrib;
    private TextField textTableRowCode;
    private TextField textTitle;

    public ExportToHtmlDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(ISettings config) {
        ExportToHtmlDialog dialog = new ExportToHtmlDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem(charset.displayName());
        }
        this.changeListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExportToHtmlDialog.this.updateCodes();
            }

            public void removeUpdate(DocumentEvent e) {
                ExportToHtmlDialog.this.updateCodes();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textTableCode.getDocument().addDocumentListener(this.changeListener);
        this.textTableRowCode.getDocument().addDocumentListener(this.changeListener);
        this.textTableHeaderCode.getDocument().addDocumentListener(this.changeListener);
        this.textTableDataCode.getDocument().addDocumentListener(this.changeListener);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void updateCodes() {
        this.labelEndTableCode.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textTableCode.getText()));
        this.labelEndTableRowCode.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textTableRowCode.getText()));
        this.labelEndTableHeaderCode.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textTableHeaderCode.getText()));
        this.labelEndTableDataCode.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textTableDataCode.getText()));
    }

    private void configToDialog() {
        try {
            this.textTitle.setText(this.config.getValue("title", new Variant("Orbada Data Table")).getString());
            this.textMetaCode.setText(this.config.getValue("meta-code", new Variant("<META NAME=\"Author\" CONTENT=\"Jan Kowalski\">\n<META NAME=\"Keywords\" CONTENT=\"orbada, table, data\">")).getString());
            this.textBodyAttrib.setText(this.config.getValue("body-attrib", new Variant("style=\"font-family:Tahoma,Verdana,Arial,Helvetica,sans-serif;\"")).getString());
            this.textTableCode.setText(this.config.getValue("table-code", new Variant("TABLE")).getString());
            this.textTableAttrib.setText(this.config.getValue("table-attrib", new Variant("width=\"100%\"")).getString());
            this.textTableRowCode.setText(this.config.getValue("table-row-code", new Variant("TR")).getString());
            this.textTableRowAttrib.setText(this.config.getValue("table-row-attrib").getString());
            this.textTableHeaderCode.setText(this.config.getValue("table-header-code", new Variant("TH")).getString());
            this.textTableHeaderAttrib.setText(this.config.getValue("table-header-attrib").getString());
            this.textTableDataCode.setText(this.config.getValue("table-data-code", new Variant("TD")).getString());
            this.textTableDataAttrib.setText(this.config.getValue("table-data-attrib").getString());
            this.textNullDataValue.setText(this.config.getValue("null-data-value", new Variant("&nbsp;")).getString());
            this.checkFirstLastAsNbsp.setSelected(this.config.getValue("first-last-as-nbsp", Boolean.valueOf(false)));
            this.checkIncludeTitles.setSelected(this.config.getValue("include-titles", new Variant(true)).getBoolean());
            this.comboCharset.setSelectedItem(this.config.getValue("charset", new Variant(Charset.defaultCharset().displayName())).getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig() {
        this.config.setValue("title", this.textTitle.getText());
        this.config.setValue("meta-code", this.textMetaCode.getText());
        this.config.setValue("body-attrib", this.textBodyAttrib.getText());
        this.config.setValue("table-code", this.textTableCode.getText());
        this.config.setValue("table-attrib", this.textTableAttrib.getText());
        this.config.setValue("table-row-code", this.textTableRowCode.getText());
        this.config.setValue("table-row-attrib", this.textTableRowAttrib.getText());
        this.config.setValue("table-header-code", this.textTableHeaderCode.getText());
        this.config.setValue("table-header-attrib", this.textTableHeaderAttrib.getText());
        this.config.setValue("table-data-code", this.textTableDataCode.getText());
        this.config.setValue("table-data-attrib", this.textTableDataAttrib.getText());
        this.config.setValue("null-data-value", this.textNullDataValue.getText());
        this.config.setValue("first-last-as-nbsp", Boolean.valueOf(this.checkFirstLastAsNbsp.isSelected()));
        this.config.setValue("include-titles", new Variant(this.checkIncludeTitles.isSelected()));
        this.config.setValue("charset", new Variant(this.comboCharset.getSelectedItem().toString()));
        this.config.store();
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!this.config.getValue("file-name").getString().equals("")) {
                lastFile = new File(this.config.getValue("file-name").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToSave((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter("Pliki HTML", new String[]{".htm", ".html"})});
        if (lastFile != null) {
            this.config.setValue("file-name", new Variant((Object)lastFile.getAbsoluteFile()));
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel18 = new JPanel();
        this.jLabel13 = new JLabel();
        this.textTableCode = new TextField();
        this.textTableAttrib = new TextField();
        this.jLabel14 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jLabel4 = new JLabel();
        this.textTitle = new TextField();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel9 = new JLabel();
        this.textBodyAttrib = new TextField();
        this.jLabel10 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel19 = new JPanel();
        this.jLabel15 = new JLabel();
        this.textTableRowCode = new TextField();
        this.textTableRowAttrib = new TextField();
        this.jLabel16 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel20 = new JPanel();
        this.jLabel21 = new JLabel();
        this.textTableHeaderCode = new TextField();
        this.textTableHeaderAttrib = new TextField();
        this.jLabel22 = new JLabel();
        this.checkIncludeTitles = new JCheckBox();
        this.labelEndTableHeaderCode = new JLabel();
        this.jPanel7 = new JPanel();
        this.jPanel21 = new JPanel();
        this.jLabel23 = new JLabel();
        this.textTableDataCode = new TextField();
        this.textTableDataAttrib = new TextField();
        this.jLabel24 = new JLabel();
        this.jLabel17 = new JLabel();
        this.textNullDataValue = new TextField();
        this.labelEndTableDataCode = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jPanel14 = new JPanel();
        this.jLabel7 = new JLabel();
        this.comboCharset = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jPanel15 = new JPanel();
        this.jPanel16 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textMetaCode = new TextArea();
        this.jPanel17 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jPanel22 = new JPanel();
        this.jPanel23 = new JPanel();
        this.labelEndTableRowCode = new JLabel();
        this.jPanel24 = new JPanel();
        this.jPanel25 = new JPanel();
        this.labelEndTableCode = new JLabel();
        this.jPanel26 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jPanel27 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel28 = new JPanel();
        this.jPanel29 = new JPanel();
        this.checkFirstLastAsNbsp = new JCheckBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToHtmlDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToHtmlDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExportToHtmlDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jPanel1.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel18.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel18Layout = new GroupLayout(this.jPanel18);
        this.jPanel18.setLayout(jPanel18Layout);
        jPanel18Layout.setHorizontalGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel18Layout.setVerticalGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel18);
        this.jLabel13.setText("<html>&lt;");
        this.jPanel1.add(this.jLabel13);
        this.textTableCode.setText("TABLE");
        this.textTableCode.setFont(new Font("Courier New", 0, 12));
        this.textTableCode.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.add((Component)this.textTableCode);
        this.textTableAttrib.setText("width=\"100%\"");
        this.textTableAttrib.setFont(new Font("Courier New", 0, 12));
        this.textTableAttrib.setPreferredSize(new Dimension(250, 20));
        this.jPanel1.add((Component)this.textTableAttrib);
        this.jLabel14.setText("<html>&gt;");
        this.jPanel1.add(this.jLabel14);
        this.jPanel2.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel11.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel2.add(this.jPanel11);
        this.jLabel4.setText("<html>&lt;<b>TITLE</b>&gt;");
        this.jPanel2.add(this.jLabel4);
        this.textTitle.setText("Orbada Data Table");
        this.textTitle.setFont(new Font("Courier New", 0, 12));
        this.textTitle.setPreferredSize(new Dimension(300, 20));
        this.jPanel2.add((Component)this.textTitle);
        this.jLabel5.setText("<html>&lt;<b>/TITLE</b>&gt;");
        this.jPanel2.add(this.jLabel5);
        this.jPanel4.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel9.setText("<html>&lt;<b>BODY</b>");
        this.jPanel4.add(this.jLabel9);
        this.textBodyAttrib.setText("style=\"font-family:Tahoma,Verdana,Arial,Helvetica,sans-serif;\"");
        this.textBodyAttrib.setFont(new Font("Courier New", 0, 12));
        this.textBodyAttrib.setPreferredSize(new Dimension(500, 20));
        this.jPanel4.add((Component)this.textBodyAttrib);
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("<html>&gt;");
        this.jPanel4.add(this.jLabel10);
        this.jPanel5.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel19.setPreferredSize(new Dimension(40, 10));
        GroupLayout jPanel19Layout = new GroupLayout(this.jPanel19);
        this.jPanel19.setLayout(jPanel19Layout);
        jPanel19Layout.setHorizontalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        jPanel19Layout.setVerticalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel5.add(this.jPanel19);
        this.jLabel15.setText("<html>&lt;");
        this.jPanel5.add(this.jLabel15);
        this.textTableRowCode.setText("TR");
        this.textTableRowCode.setFont(new Font("Courier New", 0, 12));
        this.textTableRowCode.setPreferredSize(new Dimension(100, 20));
        this.jPanel5.add((Component)this.textTableRowCode);
        this.textTableRowAttrib.setFont(new Font("Courier New", 0, 12));
        this.textTableRowAttrib.setPreferredSize(new Dimension(250, 20));
        this.jPanel5.add((Component)this.textTableRowAttrib);
        this.jLabel16.setText("<html>&gt;");
        this.jPanel5.add(this.jLabel16);
        this.jPanel6.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel20.setPreferredSize(new Dimension(60, 10));
        GroupLayout jPanel20Layout = new GroupLayout(this.jPanel20);
        this.jPanel20.setLayout(jPanel20Layout);
        jPanel20Layout.setHorizontalGroup(jPanel20Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 60, Short.MAX_VALUE));
        jPanel20Layout.setVerticalGroup(jPanel20Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel6.add(this.jPanel20);
        this.jLabel21.setText("<html>&lt;");
        this.jPanel6.add(this.jLabel21);
        this.textTableHeaderCode.setText("TH");
        this.textTableHeaderCode.setFont(new Font("Courier New", 0, 12));
        this.textTableHeaderCode.setPreferredSize(new Dimension(100, 20));
        this.jPanel6.add((Component)this.textTableHeaderCode);
        this.textTableHeaderAttrib.setFont(new Font("Courier New", 0, 12));
        this.textTableHeaderAttrib.setPreferredSize(new Dimension(250, 20));
        this.jPanel6.add((Component)this.textTableHeaderAttrib);
        this.jLabel22.setText("<html>&gt;");
        this.jPanel6.add(this.jLabel22);
        this.checkIncludeTitles.setSelected(true);
        this.checkIncludeTitles.setText(this.stringManager.getString("ExportToHtmlDialog-checkIncludeTitles-text"));
        this.checkIncludeTitles.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel6.add(this.checkIncludeTitles);
        this.labelEndTableHeaderCode.setText("<html>&lt;<b>/TH</b>&gt;");
        this.jPanel6.add(this.labelEndTableHeaderCode);
        this.jPanel7.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel21.setPreferredSize(new Dimension(60, 10));
        GroupLayout jPanel21Layout = new GroupLayout(this.jPanel21);
        this.jPanel21.setLayout(jPanel21Layout);
        jPanel21Layout.setHorizontalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 60, Short.MAX_VALUE));
        jPanel21Layout.setVerticalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel7.add(this.jPanel21);
        this.jLabel23.setText("<html>&lt;");
        this.jPanel7.add(this.jLabel23);
        this.textTableDataCode.setText("TD");
        this.textTableDataCode.setFont(new Font("Courier New", 0, 12));
        this.textTableDataCode.setPreferredSize(new Dimension(100, 20));
        this.jPanel7.add((Component)this.textTableDataCode);
        this.textTableDataAttrib.setFont(new Font("Courier New", 0, 12));
        this.textTableDataAttrib.setPreferredSize(new Dimension(250, 20));
        this.jPanel7.add((Component)this.textTableDataAttrib);
        this.jLabel24.setText("<html>&gt;");
        this.jPanel7.add(this.jLabel24);
        this.jLabel17.setText(this.stringManager.getString("ExportToHtmlDialog-empty-value-dd"));
        this.jPanel7.add(this.jLabel17);
        this.textNullDataValue.setText("&nbsp;");
        this.textNullDataValue.setFont(new Font("Courier New", 0, 12));
        this.textNullDataValue.setPreferredSize(new Dimension(60, 20));
        this.jPanel7.add((Component)this.textNullDataValue);
        this.labelEndTableDataCode.setText("<html>&lt;<b>/TD</b>&gt;");
        this.jPanel7.add(this.labelEndTableDataCode);
        this.jPanel8.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel1.setText("<html>&lt;<b>HTML</b>&gt;");
        this.jPanel8.add(this.jLabel1);
        this.jPanel9.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel3.setText("<html>&lt;<b>HEAD</b>&gt;");
        this.jPanel9.add(this.jLabel3);
        this.jPanel10.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel12.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel10.add(this.jPanel12);
        this.jLabel6.setText("<html>&lt;<b>META NAME=\"Generator\" CONTENT=\"Orbada Export To Html\" /</b>&gt;");
        this.jPanel10.add(this.jLabel6);
        this.jPanel13.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel14.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel13.add(this.jPanel14);
        this.jLabel7.setText("<html>&lt;<b>META HTTP-EQUIV=\"content-type\" CONTENT=\"text/html; charset=</b>");
        this.jPanel13.add(this.jLabel7);
        this.comboCharset.setEditable(true);
        this.comboCharset.setFont(new Font("Courier New", 0, 12));
        this.comboCharset.setPreferredSize(new Dimension(150, 22));
        this.jPanel13.add(this.comboCharset);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("<html><b>\" /</b>&gt;");
        this.jPanel13.add(this.jLabel12);
        this.jPanel15.setLayout(new BorderLayout());
        this.jPanel16.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        this.jPanel15.add((Component)this.jPanel16, "West");
        this.textMetaCode.setColumns(20);
        this.textMetaCode.setRows(5);
        this.textMetaCode.setText("<META NAME=\"Author\" CONTENT=\"Jan Kowalski\">\n<META NAME=\"Keywords\" CONTENT=\"table, data\">");
        this.textMetaCode.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane1.setViewportView((Component)this.textMetaCode);
        this.jPanel15.add((Component)this.jScrollPane1, "Center");
        this.jPanel17.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel8.setText("<html>&lt;<b>/HEAD</b>&gt;");
        this.jPanel17.add(this.jLabel8);
        this.jPanel22.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel23.setPreferredSize(new Dimension(40, 10));
        GroupLayout jPanel23Layout = new GroupLayout(this.jPanel23);
        this.jPanel23.setLayout(jPanel23Layout);
        jPanel23Layout.setHorizontalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        jPanel23Layout.setVerticalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel22.add(this.jPanel23);
        this.labelEndTableRowCode.setText("<html>&lt;<b>/TR</b>&gt;");
        this.jPanel22.add(this.labelEndTableRowCode);
        this.jPanel24.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel25.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel25Layout = new GroupLayout(this.jPanel25);
        this.jPanel25.setLayout(jPanel25Layout);
        jPanel25Layout.setHorizontalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel25Layout.setVerticalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel24.add(this.jPanel25);
        this.labelEndTableCode.setText("<html>&lt;<b>/TABLE</b>&gt;");
        this.jPanel24.add(this.labelEndTableCode);
        this.jPanel26.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel11.setText("<html>&lt;<b>/BODY</b>&gt;");
        this.jPanel26.add(this.jLabel11);
        this.jPanel27.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel2.setText("<html>&lt;<b>/HTML</b>&gt;");
        this.jPanel27.add(this.jLabel2);
        this.jPanel28.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel29.setPreferredSize(new Dimension(170, 10));
        GroupLayout jPanel29Layout = new GroupLayout(this.jPanel29);
        this.jPanel29.setLayout(jPanel29Layout);
        jPanel29Layout.setHorizontalGroup(jPanel29Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 170, Short.MAX_VALUE));
        jPanel29Layout.setVerticalGroup(jPanel29Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel28.add(this.jPanel29);
        this.checkFirstLastAsNbsp.setText(this.stringManager.getString("ExportToHtmlDialog-nbsp-first-last"));
        this.jPanel28.add(this.checkFirstLastAsNbsp);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel9, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel8, GroupLayout.Alignment.TRAILING, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel10, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel13, -1, 656, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jPanel15, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel17, GroupLayout.Alignment.TRAILING, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel4, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel6, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel7, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel28, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel22, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel24, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel26, -1, 656, Short.MAX_VALUE).addComponent(this.jPanel27, -1, 656, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel10, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jPanel13, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel15, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel17, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel28, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel22, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel24, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel26, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel27, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (this.selectFile()) {
            this.modalResult = 1;
            this.dialogToConfig();
            this.dispose();
        }
    }
}

