/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import javax.swing.JTable;
import pl.mpak.orbada.export.ExportToSqlInsertDefinition;
import pl.mpak.orbada.export.ExportToSqlInsertDialog;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.HexUtils;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class ExportToSqlInsert
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private String fileName;
    private String charset;
    private String tableName;
    private boolean toClipboard;
    private ExportToSqlInsertDefinition eti;
    private String columnNameList;

    public ExportToSqlInsert() {
        this.setText(this.stringManager.getString("ExportToSqlInsert-text"));
        this.setActionCommandKey("ExportToSqlInsert");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToSqlInsert-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-sql-insert-file");
    }

    private void localConfig() {
        try {
            this.tableName = this.getConfig().getValue("table-name").getString();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
            this.toClipboard = this.getConfig().getValue("to-clipboard", Boolean.valueOf(false));
            this.eti = ExportToSqlInsertDefinition.toDefinition(this.getConfig().getValue("def-user", (String)null));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void prepareColumnNameList(JTable table) {
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String columnName = StringUtil.replaceString((String)this.eti.getColumnName(), (String)"$(column-name)", (String)table.getColumnModel().getColumn(c).getHeaderValue().toString());
            columnName = StringUtil.replaceString((String)columnName, (String)"$(COLUMN-NAME)", (String)table.getColumnModel().getColumn(c).getHeaderValue().toString().toUpperCase());
            sb.append(columnName);
        }
        this.columnNameList = sb.toString();
    }

    private String convertValue(Variant value) throws VariantException, IOException {
        if (value.isNullValue()) {
            return this.eti.getNullValue();
        }
        switch (value.getValueType()) {
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 15: {
                return StringUtil.replaceString((String)this.eti.getNumericValue(), (String)"$(value)", (String)value.getString());
            }
            case 4: 
            case 5: 
            case 14: {
                String s = value.getString();
                if (this.eti.isDotToComma()) {
                    s = StringUtil.replaceString((String)s, (String)".", (String)",");
                }
                return StringUtil.replaceString((String)this.eti.getNumericValue(), (String)"$(value)", (String)s);
            }
            case 8: {
                String v = value.getBoolean() ? StringUtil.replaceString((String)this.eti.getTrueValue(), (String)"$(value)", (String)value.toString()) : StringUtil.replaceString((String)this.eti.getFalseValue(), (String)"$(value)", (String)value.toString());
                return v;
            }
            case 7: 
            case 19: 
            case 20: {
                return StringUtil.replaceString((String)this.eti.getTimestampValue(), (String)"$(value)", (String)value.toString());
            }
            case 11: {
                String v = value.toString();
                for (int i = 0; i < this.eti.getVarcharChars().length(); ++i) {
                    v = StringUtil.replaceString((String)v, (String)("" + this.eti.getVarcharChars().charAt(i)), (String)(this.eti.getCharPrefix() + this.eti.getVarcharChars().charAt(i)));
                }
                v = StringUtil.replaceString((String)this.eti.getVarcharValue(), (String)"$(value)", (String)v);
                return v;
            }
            case 13: 
            case 16: {
                if (this.eti.isBinaryHex()) {
                    return StringUtil.replaceString((String)this.eti.getBinaryValue(), (String)"$(value)", (String)HexUtils.convert((byte[])value.getBinary()));
                }
                return StringUtil.replaceString((String)this.eti.getBinaryValue(), (String)"$(value)", (String)value.toString());
            }
            case 9: {
                return this.convertValue(value.getVariant());
            }
        }
        return value.toString();
    }

    private void exportRow(Writer out, JTable table, int row) throws IOException, VariantException, SQLException, UseDBException {
        if (table instanceof QueryTable) {
            ((QueryTable)table).getQuery().getRecord(row);
        }
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (table.getColumnModel().getColumn(c) instanceof QueryTableColumn) {
                QueryTableColumn column = (QueryTableColumn)table.getColumnModel().getColumn(c);
                sb.append(this.convertValue(column.getField().getValue()));
                continue;
            }
            sb.append(this.convertValue(new Variant(table.getValueAt(row, c))));
        }
        String command = StringUtil.replaceString((String)this.eti.getCommand(), (String)"$(table-name)", (String)this.tableName);
        command = StringUtil.replaceString((String)command, (String)"$(TABLE-NAME)", (String)this.tableName.toUpperCase());
        command = StringUtil.replaceString((String)command, (String)"$(column-name-list)", (String)this.columnNameList);
        command = StringUtil.replaceString((String)command, (String)"$(value-list)", (String)sb.toString());
        command = StringUtil.replaceString((String)command, (String)"\\n", (String)"\n");
        command = StringUtil.replaceString((String)command, (String)"\\t", (String)"\t");
        command = StringUtil.replaceString((String)command, (String)"\\r", (String)"\r");
        out.write(command);
        out.write("\n");
    }

    private void exportTable(JTable table) {
        try {
            this.prepareColumnNameList(table);
            Writer out = null;
            out = this.toClipboard ? new StringWriter() : new PrintWriter(new File(this.fileName), this.charset);
            for (int r = 0; r < table.getRowCount(); ++r) {
                this.exportRow(out, table, r);
            }
            out.flush();
            if (this.toClipboard) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection data = new StringSelection(new String(out.toString().getBytes(), this.charset));
                clipboard.setContents(data, data);
            }
            out.close();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show(null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToSqlInsert.this.getTable(event);
                if (table != null && ExportToSqlInsertDialog.showDialog(ExportToSqlInsert.this.getConfig())) {
                    ExportToSqlInsert.this.localConfig();
                    ExportToSqlInsert.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

