/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import pl.mpak.orbada.export.ExportToSqlInsertDefinition;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ExportToSqlInsertDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkBinaryHex;
    private JCheckBox checkClipboard;
    private JCheckBox checkDotToComma;
    private Action cmCancel;
    private Action cmDeleteDef;
    private Action cmNewDef;
    private Action cmOk;
    private Action cmUpdateDef;
    private JComboBox comboCharset;
    private ComboBox comboDefinitions;
    private TextField editBinaryValue;
    private TextField editCharPrefix;
    private TextField editColumnName;
    private TextField editCommand;
    private TextField editFalseValue;
    private TextField editNullValue;
    private TextField editNumericValue;
    private TextField editTableName;
    private TextField editTimestampValue;
    private TextField editTrueValue;
    private TextField editVarcharChars;
    private TextField editVarcharValue;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;

    public ExportToSqlInsertDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(ISettings config) {
        ExportToSqlInsertDialog dialog = new ExportToSqlInsertDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem(charset.displayName());
        }
        this.comboDefinitions.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ExportToSqlInsertDefinition) {
                    this.setText(((ExportToSqlInsertDefinition)value).getName());
                }
                return this;
            }
        });
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
        SwingUtil.centerWithinScreen((Window)this);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExportToSqlInsertDialog.this.editTableName.requestFocus();
            }
        });
    }

    private void preDefinitions() {
        this.comboDefinitions.addItem((Object)new ExportToSqlInsertDefinition("Standard", "INSERT INTO \"$(table-name)\" ($(column-name-list)) VALUES ($(value-list))\\n/", "\"$(column-name)\"", "'$(value)'", "'", "'", "'$(value)'", "$(value)", "true", "false", "'$(value)'", "null", true, false));
        this.comboDefinitions.addItem((Object)new ExportToSqlInsertDefinition("Oracle", "INSERT INTO \"$(table-name)\" ($(column-name-list)) VALUES ($(value-list))\\n/", "\"$(column-name)\"", "'$(value)'", "'", "'", "to_date('$(value)', 'rrrr-mm-dd hh24:mi:ss')", "$(value)", "true", "false", "hextoraw('$(value)')", "null", true, false));
    }

    private void configToDialog() {
        try {
            String userDef;
            this.checkClipboard.setSelected(this.config.getValue("to-clipboard", Boolean.valueOf(this.checkClipboard.isSelected())));
            this.comboCharset.setSelectedItem(this.config.getValue("charset", new Variant(Charset.defaultCharset().displayName())).getString());
            this.editTableName.setText(this.config.getValue("table-name", this.editTableName.getText()));
            long defCount = this.config.getValue("def-count", Long.valueOf(0L));
            String selected = this.config.getValue("def-selected", "");
            int selectedIndex = 0;
            int i = 0;
            while ((long)i < defCount) {
                String def = this.config.getValue("def-" + i, (String)null);
                if (def != null) {
                    ExportToSqlInsertDefinition eti = ExportToSqlInsertDefinition.toDefinition(def);
                    if (eti.getName().equals(selected)) {
                        selectedIndex = i;
                    }
                    this.comboDefinitions.addItem((Object)eti);
                }
                ++i;
            }
            if (defCount == 0L) {
                this.preDefinitions();
            }
            if (this.comboDefinitions.getItemCount() > 0) {
                this.comboDefinitions.setSelectedIndex(selectedIndex);
            }
            if ((userDef = this.config.getValue("def-user", (String)null)) != null && !"".equals(userDef)) {
                ExportToSqlInsertDefinition eti = ExportToSqlInsertDefinition.toDefinition(userDef);
                this.defToDialog(eti);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void defToDialog(ExportToSqlInsertDefinition eti) {
        this.editCommand.setText(eti.getCommand());
        this.editColumnName.setText(eti.getColumnName());
        this.editVarcharValue.setText(eti.getVarcharValue());
        this.editVarcharChars.setText(eti.getVarcharChars());
        this.editCharPrefix.setText(eti.getCharPrefix());
        this.editTimestampValue.setText(eti.getTimestampValue());
        this.editNumericValue.setText(eti.getNumericValue());
        this.editTrueValue.setText(eti.getTrueValue());
        this.editFalseValue.setText(eti.getFalseValue());
        this.editBinaryValue.setText(eti.getBinaryValue());
        this.editNullValue.setText(eti.getNullValue());
        this.checkBinaryHex.setSelected(eti.isBinaryHex());
        this.checkDotToComma.setSelected(eti.isDotToComma());
    }

    private ExportToSqlInsertDefinition dialogToDef(ExportToSqlInsertDefinition eti) {
        eti.setCommand(this.editCommand.getText());
        eti.setColumnName(this.editColumnName.getText());
        eti.setVarcharValue(this.editVarcharValue.getText());
        eti.setVarcharChars(this.editVarcharChars.getText());
        eti.setCharPrefix(this.editCharPrefix.getText());
        eti.setTimestampValue(this.editTimestampValue.getText());
        eti.setNumericValue(this.editNumericValue.getText());
        eti.setTrueValue(this.editTrueValue.getText());
        eti.setFalseValue(this.editFalseValue.getText());
        eti.setBinaryValue(this.editBinaryValue.getText());
        eti.setNullValue(this.editNullValue.getText());
        eti.setBinaryHex(this.checkBinaryHex.isSelected());
        eti.setDotToComma(this.checkDotToComma.isSelected());
        return eti;
    }

    private void dialogToConfig() {
        ExportToSqlInsertDefinition userEti = new ExportToSqlInsertDefinition("UserCurrentDefinition");
        this.dialogToDef(userEti);
        this.config.setValue("table-name", this.editTableName.getText());
        this.config.setValue("def-selected", ((ExportToSqlInsertDefinition)this.comboDefinitions.getSelectedItem()).getName());
        this.config.setValue("def-user", ExportToSqlInsertDefinition.toString(userEti));
        for (int i = 0; i < this.comboDefinitions.getItemCount(); ++i) {
            this.config.setValue("def-" + i, ExportToSqlInsertDefinition.toString((ExportToSqlInsertDefinition)this.comboDefinitions.getItemAt(i)));
        }
        this.config.setValue("def-count", Long.valueOf(this.comboDefinitions.getItemCount()));
        this.config.setValue("charset", new Variant(this.comboCharset.getSelectedItem().toString()));
        this.config.setValue("to-clipboard", Boolean.valueOf(this.checkClipboard.isSelected()));
        this.config.store();
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!this.config.getValue("file-name").getString().equals("")) {
                lastFile = new File(this.config.getValue("file-name").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToSave((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("ExportToSqlInsertDialog-sql-files"), new String[]{".sql"})});
        if (lastFile != null) {
            this.config.setValue("file-name", new Variant((Object)lastFile.getAbsoluteFile()));
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmNewDef = new Action();
        this.cmUpdateDef = new Action();
        this.cmDeleteDef = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.editTableName = new TextField();
        this.jLabel2 = new JLabel();
        this.editCommand = new TextField();
        this.jLabel3 = new JLabel();
        this.editColumnName = new TextField();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.editVarcharValue = new TextField();
        this.jLabel5 = new JLabel();
        this.editVarcharChars = new TextField();
        this.jLabel6 = new JLabel();
        this.editCharPrefix = new TextField();
        this.jLabel7 = new JLabel();
        this.editTimestampValue = new TextField();
        this.jLabel8 = new JLabel();
        this.editNumericValue = new TextField();
        this.jLabel9 = new JLabel();
        this.editTrueValue = new TextField();
        this.jLabel10 = new JLabel();
        this.editNullValue = new TextField();
        this.jLabel11 = new JLabel();
        this.editBinaryValue = new TextField();
        this.checkBinaryHex = new JCheckBox();
        this.checkDotToComma = new JCheckBox();
        this.jLabel14 = new JLabel();
        this.editFalseValue = new TextField();
        this.jLabel15 = new JLabel();
        this.jLabel12 = new JLabel();
        this.comboDefinitions = new ComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.comboCharset = new JComboBox();
        this.jLabel13 = new JLabel();
        this.checkClipboard = new JCheckBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToSqlInsertDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToSqlInsertDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmNewDef.setActionCommandKey("cmNewDef");
        this.cmNewDef.setText(this.stringManager.getString("ExportToSqlInsertDialog-cmNewDef-text"));
        this.cmNewDef.setTooltip(this.stringManager.getString("ExportToSqlInsertDialog-cmNewDef-hint"));
        this.cmNewDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToSqlInsertDialog.this.cmNewDefActionPerformed(evt);
            }
        });
        this.cmUpdateDef.setActionCommandKey("cmUpdateDef");
        this.cmUpdateDef.setText(this.stringManager.getString("ExportToSqlInsertDialog-cmUpdateDef-text"));
        this.cmUpdateDef.setTooltip(this.stringManager.getString("ExportToSqlInsertDialog-cmUpdateDef-hint"));
        this.cmUpdateDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToSqlInsertDialog.this.cmUpdateDefActionPerformed(evt);
            }
        });
        this.cmDeleteDef.setActionCommandKey("cmDeleteDef");
        this.cmDeleteDef.setText(this.stringManager.getString("ExportToSqlInsertDialog-cmDeleteDef-text"));
        this.cmDeleteDef.setTooltip(this.stringManager.getString("ExportToSqlInsertDialog-cmDeleteDef-hint"));
        this.cmDeleteDef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToSqlInsertDialog.this.cmDeleteDefActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExportToSqlInsertDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("ExportToSqlInsertDialog-table-name-dd"));
        this.editTableName.setText("TABLE_NAME");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("ExportToSqlInsertDialog-command-dd"));
        this.editCommand.setText("INSERT INTO \"$(table-name)\" ($(column-name-list)) VALUES ($(value-list))\\n/");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("ExportToSqlInsertDialog-column-dd"));
        this.editColumnName.setText("\"$(column-name)\"");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("ExportToSqlInsertDialog-data-conversion")));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("ExportToSqlInsertDialog-char-seq-dd"));
        this.editVarcharValue.setText("'$(value)'");
        this.jLabel5.setText(this.stringManager.getString("ExportToSqlInsertDialog-before-char-dd"));
        this.editVarcharChars.setText("'");
        this.jLabel6.setText(this.stringManager.getString("ExportToSqlInsertDialog-char-dd"));
        this.editCharPrefix.setText("'");
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("ExportToSqlInsertDialog-date-time-dd"));
        this.editTimestampValue.setText("to_date('$(value)', 'rrrr-mm-dd hh24:mi:ss')");
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.stringManager.getString("ExportToSqlInsertDialog-number-dd"));
        this.editNumericValue.setText("$(value)");
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText(this.stringManager.getString("ExportToSqlInsertDialog-boolean-dd"));
        this.editTrueValue.setText("true");
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText(this.stringManager.getString("ExportToSqlInsertDialog-null-value-dd"));
        this.editNullValue.setText(null);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText(this.stringManager.getString("ExportToSqlInsertDialog-binary-dd"));
        this.editBinaryValue.setText("hextoraw('$(value)')");
        this.checkBinaryHex.setSelected(true);
        this.checkBinaryHex.setText(this.stringManager.getString("ExportToSqlInsertDialog-checkBinaryHex-text"));
        this.checkDotToComma.setText(this.stringManager.getString("ExportToSqlInsertDialog-checkDotToComma-text"));
        this.jLabel14.setText(this.stringManager.getString("ExportToSqlInsertDialog-true-dd"));
        this.editFalseValue.setText("false");
        this.jLabel15.setText(this.stringManager.getString("ExportToSqlInsertDialog-false-dd"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editVarcharValue, -1, 222, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editVarcharChars, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editCharPrefix, -2, 37, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editTimestampValue, -1, 428, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editNumericValue, -1, 305, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDotToComma)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editTrueValue, -1, 171, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editFalseValue, -1, 174, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel11, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editBinaryValue, -1, 333, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBinaryHex)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel10, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editNullValue, -1, 428, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 16, -2).addComponent(this.jLabel5).addComponent((Component)this.editVarcharChars, -2, -1, -2).addComponent(this.jLabel6).addComponent((Component)this.editCharPrefix, -2, -1, -2).addComponent((Component)this.editVarcharValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, 16, -2).addComponent((Component)this.editTimestampValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8, -2, 16, -2).addComponent(this.checkDotToComma).addComponent((Component)this.editNumericValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9, -2, 16, -2).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent((Component)this.editTrueValue, -2, -1, -2).addComponent((Component)this.editFalseValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11, -2, 16, -2).addComponent(this.checkBinaryHex).addComponent((Component)this.editBinaryValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10, -2, 16, -2).addComponent((Component)this.editNullValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText(this.stringManager.getString("ExportToSqlInsertDialog-definition-dd"));
        this.comboDefinitions.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExportToSqlInsertDialog.this.comboDefinitionsItemStateChanged(evt);
            }
        });
        this.jButton1.setAction((javax.swing.Action)this.cmNewDef);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.setAction((javax.swing.Action)this.cmUpdateDef);
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton3.setAction((javax.swing.Action)this.cmDeleteDef);
        this.jButton3.setMargin(new Insets(2, 2, 2, 2));
        this.comboCharset.setEditable(true);
        this.comboCharset.setFont(new Font("Courier New", 0, 12));
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText(this.stringManager.getString("ExportToSqlInsertDialog-charcode-dd"));
        this.checkClipboard.setText(this.stringManager.getString("ExportToSqlInsertDialog-checkClipboard-text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -1, 102, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.editColumnName, -2, 210, -2).addComponent((Component)this.editCommand, -1, 461, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.comboCharset, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent((Component)this.editTableName, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.comboDefinitions, GroupLayout.Alignment.LEADING, -1, 211, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)))).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.checkClipboard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 260, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12, -2, 14, -2).addComponent((Component)this.comboDefinitions, -2, -1, -2).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13, -2, 16, -2).addComponent(this.comboCharset, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 14, -2).addComponent((Component)this.editTableName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 16, -2).addComponent((Component)this.editCommand, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 16, -2).addComponent((Component)this.editColumnName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.checkClipboard)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (this.checkClipboard.isSelected() || this.selectFile()) {
            this.modalResult = 1;
            this.dialogToConfig();
            this.dispose();
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void comboDefinitionsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && evt.getItem() instanceof ExportToSqlInsertDefinition) {
            this.defToDialog((ExportToSqlInsertDefinition)evt.getItem());
        }
    }

    private void cmUpdateDefActionPerformed(ActionEvent evt) {
        if (this.comboDefinitions.getSelectedItem() instanceof ExportToSqlInsertDefinition) {
            this.dialogToDef((ExportToSqlInsertDefinition)this.comboDefinitions.getSelectedItem());
        }
    }

    private void cmDeleteDefActionPerformed(ActionEvent evt) {
        if (this.comboDefinitions.getSelectedItem() instanceof ExportToSqlInsertDefinition && MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)(this.stringManager.getString("ExportToSqlInsertDialog-delete-def-q") + ((ExportToSqlInsertDefinition)this.comboDefinitions.getSelectedItem()).getName()), (int[])ModalResult.YESNO, (int)3) == 5) {
            this.comboDefinitions.removeItem(this.comboDefinitions.getSelectedItem());
            if (this.comboDefinitions.getItemCount() == 0) {
                this.preDefinitions();
            }
        }
    }

    private void cmNewDefActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, this.stringManager.getString("ExportToSqlInsertDialog-input-name-dd"), this.stringManager.getString("ExportToSqlInsertDialog-def-name"), 3);
        if (name != null) {
            ExportToSqlInsertDefinition eti = new ExportToSqlInsertDefinition(name);
            this.dialogToDef(eti);
            this.comboDefinitions.addItem((Object)eti);
            this.comboDefinitions.setSelectedItem((Object)eti);
        }
    }
}

