/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JTable;
import pl.mpak.orbada.export.ExportToXmlDialog;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class ExportToXml
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private String resultsCode;
    private String rowCode;
    private String columnCode;
    private String columnAttrCode;
    private String dataBeginCode;
    private String dataEndCode;
    private String fileName;
    private String charset;
    private DecimalFormat df;

    public ExportToXml() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(".".charAt(0));
        this.df = new DecimalFormat("0.##########", dfs);
        this.setText(this.stringManager.getString("ExportToXml-text"));
        this.setActionCommandKey("ExportToXml");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToXml-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-xml-file");
    }

    private void localConfig() {
        try {
            this.resultsCode = this.getConfig().getValue("results").getString();
            this.rowCode = this.getConfig().getValue("row").getString();
            this.columnCode = this.getConfig().getValue("column").getString();
            this.columnAttrCode = this.getConfig().getValue("column-attr").getString();
            this.dataBeginCode = this.getConfig().getValue("data-begin").getString();
            this.dataEndCode = this.getConfig().getValue("data-end").getString();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void exportRow(PrintWriter out, JTable table, int row) {
        Variant v = new Variant(this.df);
        out.println("  <" + this.rowCode + ">");
        for (int c = 0; c < table.getColumnCount(); ++c) {
            String cc = StringUtil.replaceString((String)this.columnCode, (String)"$(column-name)", (String)table.getColumnModel().getColumn(c).getHeaderValue().toString());
            String ca = StringUtil.replaceString((String)this.columnAttrCode, (String)"$(column-name)", (String)table.getColumnModel().getColumn(c).getHeaderValue().toString());
            out.print("    <" + cc + (!"".equals(ca) ? " " + ca : "") + ">" + this.dataBeginCode);
            v.setValue(table.getValueAt(row, c));
            out.print(v.toString());
            out.println(this.dataEndCode + "</" + cc + ">");
        }
        out.println("  </" + this.rowCode + ">");
    }

    private void exportTable(JTable table) {
        try {
            PrintWriter out = new PrintWriter(new File(this.fileName), this.charset);
            out.println(String.format("<?xml version='1.0' encoding='%s' ?>", this.charset));
            out.println("<" + this.resultsCode + ">");
            for (int r = 0; r < table.getRowCount(); ++r) {
                this.exportRow(out, table, r);
            }
            out.println("</" + this.resultsCode + ">");
            out.close();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToXml.this.getTable(event);
                if (table != null && ExportToXmlDialog.showDialog(ExportToXml.this.getConfig())) {
                    ExportToXml.this.localConfig();
                    ExportToXml.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

