/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pl.mpak.orbada.export.OrbadaExportPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ExportToXmlDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private DocumentListener changeListener;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboCharset;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel labelColumn;
    private JLabel labelResults;
    private JLabel labelRow;
    private TextField textColumn;
    private TextField textColumnAttr;
    private TextField textDataBegin;
    private TextField textDataEnd;
    private TextField textResults;
    private TextField textRow;

    public ExportToXmlDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(ISettings config) {
        ExportToXmlDialog dialog = new ExportToXmlDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem(charset.displayName());
        }
        this.changeListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExportToXmlDialog.this.updateCodes();
            }

            public void removeUpdate(DocumentEvent e) {
                ExportToXmlDialog.this.updateCodes();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textResults.getDocument().addDocumentListener(this.changeListener);
        this.textRow.getDocument().addDocumentListener(this.changeListener);
        this.textColumn.getDocument().addDocumentListener(this.changeListener);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
    }

    private void updateCodes() {
        this.labelResults.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textResults.getText()));
        this.labelRow.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textRow.getText()));
        this.labelColumn.setText(String.format("<html>&lt;<b>/%s</b>&gt;", this.textColumn.getText()));
    }

    private void configToDialog() {
        try {
            this.textResults.setText(this.config.getValue("results", this.textResults.getText()));
            this.textRow.setText(this.config.getValue("row", this.textRow.getText()));
            this.textColumn.setText(this.config.getValue("column", this.textColumn.getText()));
            this.textColumnAttr.setText(this.config.getValue("column-attr", this.textColumnAttr.getText()));
            this.textDataBegin.setText(this.config.getValue("data-begin", this.textDataBegin.getText()));
            this.textDataEnd.setText(this.config.getValue("data-end", this.textDataEnd.getText()));
            this.comboCharset.setSelectedItem(this.config.getValue("charset", Charset.defaultCharset().displayName()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig() {
        this.config.setValue("results", this.textResults.getText());
        this.config.setValue("row", this.textRow.getText());
        this.config.setValue("column", this.textColumn.getText());
        this.config.setValue("column-attr", this.textColumnAttr.getText());
        this.config.setValue("data-begin", this.textDataBegin.getText());
        this.config.setValue("data-end", this.textDataEnd.getText());
        this.config.setValue("charset", this.comboCharset.getSelectedItem().toString());
        this.config.store();
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!this.config.getValue("file-name").getString().equals("")) {
                lastFile = new File(this.config.getValue("file-name").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToSave((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("ExportToXmlDialog-xml-files"), new String[]{".xml"})});
        if (lastFile != null) {
            this.config.setValue("file-name", new Variant((Object)lastFile.getAbsoluteFile()));
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jLabel1 = new JLabel();
        this.comboCharset = new JComboBox();
        this.jLabel2 = new JLabel();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textResults = new TextField();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.textRow = new TextField();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel7 = new JLabel();
        this.textColumn = new TextField();
        this.textColumnAttr = new TextField();
        this.jLabel8 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel7 = new JPanel();
        this.textDataBegin = new TextField();
        this.jLabel9 = new JLabel();
        this.textDataEnd = new TextField();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.labelColumn = new JLabel();
        this.jPanel10 = new JPanel();
        this.jPanel11 = new JPanel();
        this.labelRow = new JLabel();
        this.jPanel12 = new JPanel();
        this.labelResults = new JLabel();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToXmlDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToXmlDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExportToXmlDialog-title"));
        this.setModal(true);
        this.jLabel1.setText("<html><b>&lt;?xml version='1.0' encoding='</b>");
        this.comboCharset.setEditable(true);
        this.comboCharset.setFont(new Font("Courier New", 0, 12));
        this.jLabel2.setText("<html><b>' ?&gt;</b>");
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jPanel1.setLayout(new FlowLayout(0, 2, 2));
        this.jLabel3.setText("<html><b>&lt;</b>");
        this.jPanel1.add(this.jLabel3);
        this.textResults.setText("results");
        this.textResults.setPreferredSize(new Dimension(90, 20));
        this.jPanel1.add((Component)this.textResults);
        this.jLabel4.setText("<html><b>&gt;</b>");
        this.jPanel1.add(this.jLabel4);
        this.jPanel2.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel5.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel2.add(this.jPanel5);
        this.jLabel5.setText("<html><b>&lt;</b>");
        this.jPanel2.add(this.jLabel5);
        this.textRow.setText("row");
        this.textRow.setPreferredSize(new Dimension(90, 20));
        this.jPanel2.add((Component)this.textRow);
        this.jLabel6.setText("<html><b>&gt;</b>");
        this.jPanel2.add(this.jLabel6);
        this.jPanel3.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel6.setPreferredSize(new Dimension(40, 10));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel3.add(this.jPanel6);
        this.jLabel7.setText("<html><b>&lt;</b>");
        this.jPanel3.add(this.jLabel7);
        this.textColumn.setText("$(column-name)");
        this.textColumn.setPreferredSize(new Dimension(90, 20));
        this.jPanel3.add((Component)this.textColumn);
        this.textColumnAttr.setPreferredSize(new Dimension(180, 20));
        this.jPanel3.add((Component)this.textColumnAttr);
        this.jLabel8.setText("<html><b>&gt;</b>");
        this.jPanel3.add(this.jLabel8);
        this.jPanel4.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel7.setPreferredSize(new Dimension(60, 10));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 60, Short.MAX_VALUE));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel4.add(this.jPanel7);
        this.textDataBegin.setText("<![CDATA[");
        this.textDataBegin.setPreferredSize(new Dimension(90, 20));
        this.jPanel4.add((Component)this.textDataBegin);
        this.jLabel9.setText("..data..");
        this.jPanel4.add(this.jLabel9);
        this.textDataEnd.setText("]]>");
        this.textDataEnd.setPreferredSize(new Dimension(90, 20));
        this.jPanel4.add((Component)this.textDataEnd);
        this.jPanel8.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel9.setPreferredSize(new Dimension(40, 10));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel8.add(this.jPanel9);
        this.labelColumn.setText("<html><b>&lt;$(column-name)&gt;</b>");
        this.jPanel8.add(this.labelColumn);
        this.jPanel10.setLayout(new FlowLayout(0, 2, 2));
        this.jPanel11.setPreferredSize(new Dimension(20, 10));
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.jPanel10.add(this.jPanel11);
        this.labelRow.setText("<html><b>&lt;row&gt;</b>");
        this.jPanel10.add(this.labelRow);
        this.jPanel12.setLayout(new FlowLayout(0, 2, 2));
        this.labelResults.setText("<html><b>&lt;results&gt;</b>");
        this.jPanel12.add(this.labelResults);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCharset, 0, 178, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jPanel8, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addComponent(this.jPanel10, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE).addComponent(this.jPanel12, GroupLayout.Alignment.LEADING, -1, 386, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboCharset, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel10, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel12, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (this.selectFile()) {
            this.modalResult = 1;
            this.dialogToConfig();
            this.dispose();
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

