/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.xmldataview.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import pl.mpak.orbada.xmldataview.gui.IconAndTipCarrier;

public class IconAndTipRenderer
extends JLabel
implements TreeCellRenderer {
    Color backColor = new Color(255, 204, 255);
    Icon openIcon;
    Icon closedIcon;
    Icon leafIcon;
    String tipText = "";

    public IconAndTipRenderer(Icon open, Icon closed, Icon leaf) {
        this.openIcon = open;
        this.closedIcon = closed;
        this.leafIcon = leaf;
        this.setBackground(this.backColor);
        this.setForeground(Color.black);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(value.toString());
        if (selected) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
        IconAndTipCarrier itc = null;
        if (value instanceof DefaultMutableTreeNode) {
            Object uo = ((DefaultMutableTreeNode)value).getUserObject();
            if (uo instanceof IconAndTipCarrier) {
                itc = (IconAndTipCarrier)uo;
            }
        } else if (value instanceof IconAndTipCarrier) {
            itc = (IconAndTipCarrier)value;
        }
        if (itc != null && itc.getIcon() != null) {
            this.setIcon(itc.getIcon());
            this.tipText = itc.getToolTipText();
        } else {
            this.tipText = " ";
            if (expanded) {
                this.setIcon(this.openIcon);
            } else if (leaf) {
                this.setIcon(this.leafIcon);
            } else {
                this.setIcon(this.closedIcon);
            }
        }
        return this;
    }

    public String getToolTipText() {
        return this.tipText;
    }
}

