/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.jaybird.services.JaybirdExplainPlanService;
import pl.mpak.orbada.jaybird.services.JaybirdGeneralSettingsService;
import pl.mpak.orbada.jaybird.services.JaybirdMenuService;
import pl.mpak.orbada.jaybird.services.JaybirdToolConfigurationActionService;
import pl.mpak.orbada.jaybird.services.JaybirdToolbarService;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaJaybirdPlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    public static final String firebirdDriverType = "Firebird";
    public static final String jaybirdDriverClass = "org.firebirdsql.jdbc.FBDriver";
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-jaybird-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaJaybirdPlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("plugin-description"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,Firebird,Jaybird";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 1, 5).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-jaybird-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(firebirdDriverType);
        classList.add(JaybirdGeneralSettingsService.class);
        classList.add(JaybirdToolConfigurationActionService.class);
        classList.add(JaybirdMenuService.class);
        classList.add(JaybirdToolbarService.class);
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(JaybirdExplainPlanService.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    static {
        classList = new ArrayList();
    }
}

