/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.firebirdsql.management.FBManager;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.jaybird.OrbadaJaybirdPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateDatabaseDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    private Thread worker;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkForceCreate;
    private Action cmClose;
    private Action cmCreate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JTabbedPane tabbed;
    private TextField textDatabase;
    private TextField textHost;
    private JPasswordField textPassword;
    private TextField textPort;
    private TextField textUser;

    public CreateDatabaseDialog() {
        super(SwingUtil.getRootFrame(), true);
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CreateDatabaseDialog dialog = new CreateDatabaseDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("jaybird-server");
        this.checkForceCreate.setVisible(false);
        this.textHost.setText(this.settings.getValue("host", this.textHost.getText()));
        this.textUser.setText(this.settings.getValue("user-name", this.textUser.getText()));
        this.textPort.setText(this.settings.getValue("port", this.textPort.getText()));
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.settings.setValue("host", this.textHost.getText());
        this.settings.setValue("user-name", this.textUser.getText());
        this.settings.setValue("port", this.textPort.getText());
        this.settings.store();
        super.dispose();
    }

    private void enableControls(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CreateDatabaseDialog.this.textHost.setEnabled(value);
                CreateDatabaseDialog.this.textUser.setEnabled(value);
                CreateDatabaseDialog.this.textPassword.setEnabled(value);
                CreateDatabaseDialog.this.textDatabase.setEnabled(value);
                CreateDatabaseDialog.this.textPort.setEnabled(value);
                CreateDatabaseDialog.this.cmCreate.setEnabled(value);
                CreateDatabaseDialog.this.cmClose.setEnabled(value);
            }
        });
    }

    private void createDatabase() {
        final FBManager manager = new FBManager();
        try {
            this.enableControls(false);
            manager.setServer(this.textHost.getText());
            manager.setUserName(this.textUser.getText());
            manager.setPassword(new String(this.textPassword.getPassword()));
            manager.setPort(Integer.valueOf(this.textPort.getText()).intValue());
            manager.setFileName(this.textDatabase.getText());
            manager.setCreateOnStart(true);
            this.worker = new Thread("Backup Firbird Database"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        manager.start();
                        manager.stop();
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)"Jaybird", (String)stringManager.getString("CreateDatabaseDialog.message_database_created"), (int)1, (int)1);
                            }
                        });
                    }
                    catch (Exception ex) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("Error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    }
                    finally {
                        CreateDatabaseDialog.this.enableControls(true);
                    }
                }
            };
            this.worker.start();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.enableControls(true);
        }
    }

    private void initComponents() {
        this.cmCreate = new Action();
        this.cmClose = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.tabbed = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.textHost = new TextField();
        this.jLabel3 = new JLabel();
        this.textUser = new TextField();
        this.jLabel4 = new JLabel();
        this.textPassword = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.textDatabase = new TextField();
        this.jLabel6 = new JLabel();
        this.textPort = new TextField();
        this.checkForceCreate = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.cmCreate.setActionCommandKey("cmCreate");
        this.cmCreate.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmCreate.setText(stringManager.getString("cmCreate.text"));
        this.cmCreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseDialog.this.cmCreateActionPerformed(evt);
            }
        });
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose.text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("CreateDatabaseDialog.title"));
        this.buttonOk.setAction((javax.swing.Action)this.cmCreate);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.tabbed.setFocusable(false);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("Host-dd"));
        this.textHost.setText("localhost");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("User-dd"));
        this.textUser.setText("SYSDBA");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("Password-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(stringManager.getString("Database-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(stringManager.getString("Port-dd"));
        this.textPort.setText("3050");
        this.checkForceCreate.setText(stringManager.getString("ForceCreate"));
        this.jLabel1.setText(stringManager.getString("CreateDatabaseDialog.label_info_page_size"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 502, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 125, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, 124, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.textPort, GroupLayout.Alignment.LEADING, -2, 95, -2).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.textUser, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.textHost, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.textPassword, GroupLayout.Alignment.LEADING, -2, 195, -2)).addComponent((Component)this.textDatabase, GroupLayout.Alignment.LEADING, -1, 374, Short.MAX_VALUE).addComponent(this.checkForceCreate, GroupLayout.Alignment.LEADING)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.textPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textDatabase, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkForceCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jLabel1).addContainerGap()));
        this.tabbed.addTab(stringManager.getString("Settings"), this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbed, GroupLayout.Alignment.LEADING, -1, 527, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbed, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCreateActionPerformed(ActionEvent evt) {
        this.createDatabase();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

