/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.firebirdsql.management.FBUserManager;
import org.firebirdsql.management.User;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.jaybird.OrbadaJaybirdPlugin;
import pl.mpak.orbada.jaybird.gui.UserEditDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DatabaseUsersDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    private Thread worker;
    private FBUserManager manager;
    private OutputStream logger;
    private ArrayList<User> userList;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonNew;
    private JButton buttonOk;
    private Action cmClose;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmGet;
    private Action cmNew;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel panelLog;
    private JPanel panelUsers;
    private JTabbedPane tabbed;
    private Table tableUsers;
    private TextField textHost;
    private TextArea textLog;
    private JPasswordField textPassword;
    private TextField textPort;
    private TextField textUser;

    public DatabaseUsersDialog() {
        super(SwingUtil.getRootFrame(), true);
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DatabaseUsersDialog dialog = new DatabaseUsersDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("jaybird-server");
        this.userList = new ArrayList();
        this.tableUsers.setModel(this.getUserTableModel());
        this.tableUsers.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 40, stringManager.getString("Id")));
        this.tableUsers.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(2, 150, stringManager.getString("User")));
        this.tableUsers.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(3, 200, stringManager.getString("FullUserName")));
        this.tableUsers.setEnabled(false);
        this.textHost.setText(this.settings.getValue("host", this.textHost.getText()));
        this.textUser.setText(this.settings.getValue("user-name", this.textUser.getText()));
        this.textPort.setText(this.settings.getValue("port", this.textPort.getText()));
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete});
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.settings.setValue("host", this.textHost.getText());
        this.settings.setValue("user-name", this.textUser.getText());
        this.settings.setValue("port", this.textPort.getText());
        this.settings.store();
        super.dispose();
    }

    private void enableControls(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DatabaseUsersDialog.this.textHost.setEnabled(value);
                DatabaseUsersDialog.this.textUser.setEnabled(value);
                DatabaseUsersDialog.this.textPassword.setEnabled(value);
                DatabaseUsersDialog.this.textPort.setEnabled(value);
                DatabaseUsersDialog.this.cmGet.setEnabled(value);
                DatabaseUsersDialog.this.cmClose.setEnabled(value);
                DatabaseUsersDialog.this.tableUsers.setEnabled(value);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DatabaseUsersDialog.this.cmNew.setEnabled(value && DatabaseUsersDialog.this.manager != null);
                        DatabaseUsersDialog.this.cmEdit.setEnabled(value && DatabaseUsersDialog.this.tableUsers.getSelectedRow() >= 0);
                        DatabaseUsersDialog.this.cmDelete.setEnabled(value && DatabaseUsersDialog.this.tableUsers.getSelectedRow() >= 0);
                    }
                });
            }
        });
    }

    private TableModel getUserTableModel() {
        return new AbstractTableModel(){

            public int getRowCount() {
                return DatabaseUsersDialog.this.userList.size();
            }

            public int getColumnCount() {
                return 0;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                User u = (User)DatabaseUsersDialog.this.userList.get(rowIndex);
                switch (columnIndex) {
                    case 1: {
                        return u.getUserId();
                    }
                    case 2: {
                        return u.getUserName();
                    }
                    case 3: {
                        StringBuffer sb = new StringBuffer();
                        if (u.getFirstName() != null) {
                            sb.append(u.getFirstName());
                        }
                        if (u.getMiddleName() != null) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(u.getMiddleName());
                        }
                        if (u.getLastName() != null) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(u.getLastName());
                        }
                        return sb.toString();
                    }
                }
                return null;
            }
        };
    }

    private OutputStream getLogger() {
        if (this.logger == null) {
            this.logger = new OutputStream(){
                final StringBuffer sb = new StringBuffer();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(int b) throws IOException {
                    StringBuffer stringBuffer = this.sb;
                    synchronized (stringBuffer) {
                        this.sb.append((char)b);
                    }
                    if (this.sb.length() > 10000) {
                        this.flush();
                    }
                }

                public void flush() throws IOException {
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            StringBuffer stringBuffer = sb;
                            synchronized (stringBuffer) {
                                DatabaseUsersDialog.this.textLog.append(sb.toString());
                                sb.setLength(0);
                            }
                        }
                    });
                }
            };
        }
        return this.logger;
    }

    private void getUserList() {
        this.manager = new FBUserManager();
        try {
            this.enableControls(false);
            this.manager.setHost(this.textHost.getText());
            this.manager.setUser(this.textUser.getText());
            this.manager.setPassword(new String(this.textPassword.getPassword()));
            this.manager.setPort(Integer.valueOf(this.textPort.getText()).intValue());
            this.manager.setLogger(this.getLogger());
            this.worker = new Thread("Firbird Database User List"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DatabaseUsersDialog.this.userList.clear();
                        Map map = DatabaseUsersDialog.this.manager.getUsers();
                        for (Object o : map.values()) {
                            if (!(o instanceof User)) continue;
                            DatabaseUsersDialog.this.userList.add((User)o);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                DatabaseUsersDialog.this.tableUsers.revalidate();
                                DatabaseUsersDialog.this.tabbed.setSelectedComponent(DatabaseUsersDialog.this.panelUsers);
                                if (DatabaseUsersDialog.this.userList.size() > 0) {
                                    DatabaseUsersDialog.this.tableUsers.changeSelection(0, 1);
                                    DatabaseUsersDialog.this.tableUsers.requestFocusInWindow();
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        DatabaseUsersDialog.this.manager = null;
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("Error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    }
                    finally {
                        try {
                            DatabaseUsersDialog.this.getLogger().flush();
                        }
                        catch (IOException iOException) {}
                        DatabaseUsersDialog.this.enableControls(true);
                    }
                }
            };
            this.worker.start();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.enableControls(true);
        }
    }

    private void newUser(final User user) {
        try {
            this.enableControls(false);
            this.worker = new Thread("Firbird Database New User"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DatabaseUsersDialog.this.manager.add(user);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                DatabaseUsersDialog.this.userList.add(user);
                                DatabaseUsersDialog.this.tableUsers.revalidate();
                                DatabaseUsersDialog.this.tableUsers.changeSelection(DatabaseUsersDialog.this.userList.size() - 1, 1);
                            }
                        });
                    }
                    catch (Exception ex) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("Error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    }
                    finally {
                        try {
                            DatabaseUsersDialog.this.getLogger().flush();
                        }
                        catch (IOException iOException) {}
                        DatabaseUsersDialog.this.enableControls(true);
                    }
                }
            };
            this.worker.start();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.enableControls(true);
        }
    }

    private void updateUser(final User user) {
        try {
            this.enableControls(false);
            this.worker = new Thread("Firbird Database Update User"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DatabaseUsersDialog.this.manager.update(user);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                DatabaseUsersDialog.this.tableUsers.revalidate();
                            }
                        });
                    }
                    catch (Exception ex) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("Error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    }
                    finally {
                        try {
                            DatabaseUsersDialog.this.getLogger().flush();
                        }
                        catch (IOException iOException) {}
                        DatabaseUsersDialog.this.enableControls(true);
                    }
                }
            };
            this.worker.start();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.enableControls(true);
        }
    }

    private void deleteUser(final User user) {
        try {
            this.enableControls(false);
            this.worker = new Thread("Firbird Database Delete User"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DatabaseUsersDialog.this.manager.delete(user);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                DatabaseUsersDialog.this.userList.remove(user);
                                DatabaseUsersDialog.this.tableUsers.revalidate();
                                if (DatabaseUsersDialog.this.userList.size() > 0) {
                                    DatabaseUsersDialog.this.tableUsers.changeSelection(0, 1);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("Error"), (String)ex.getMessage(), (int)1, (int)0);
                            }
                        });
                    }
                    finally {
                        try {
                            DatabaseUsersDialog.this.getLogger().flush();
                        }
                        catch (IOException iOException) {}
                        DatabaseUsersDialog.this.enableControls(true);
                    }
                }
            };
            this.worker.start();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.enableControls(true);
        }
    }

    private void initComponents() {
        this.cmGet = new Action();
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.tabbed = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.textHost = new TextField();
        this.jLabel3 = new JLabel();
        this.textUser = new TextField();
        this.jLabel4 = new JLabel();
        this.textPassword = new JPasswordField();
        this.jLabel6 = new JLabel();
        this.textPort = new TextField();
        this.panelUsers = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tableUsers = new Table();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.panelLog = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textLog = new TextArea();
        this.cmGet.setActionCommandKey("cmGet");
        this.cmGet.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmGet.setText(stringManager.getString("cmGet.text"));
        this.cmGet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabaseUsersDialog.this.cmGetActionPerformed(evt);
            }
        });
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose.text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabaseUsersDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setActionCommandKey("cmNew");
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/new16.gif")));
        this.cmNew.setText(stringManager.getString("cmNew.text"));
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabaseUsersDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setActionCommandKey("cmEdit");
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/edit16.gif")));
        this.cmEdit.setText(stringManager.getString("cmEdit.text"));
        this.cmEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabaseUsersDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setActionCommandKey("cmDelete");
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/trash.gif")));
        this.cmDelete.setText(stringManager.getString("cmDelete.text"));
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabaseUsersDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("DatabaseUsersDialog.title"));
        this.buttonOk.setAction((javax.swing.Action)this.cmGet);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.tabbed.setFocusable(false);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("Host-dd"));
        this.textHost.setText("localhost");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("User-dd"));
        this.textUser.setText("SYSDBA");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("Password-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(stringManager.getString("Port-dd"));
        this.textPort.setText("3050");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 125, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 124, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textUser, -1, 304, Short.MAX_VALUE).addComponent((Component)this.textHost, -1, 304, Short.MAX_VALUE).addComponent(this.textPassword, -1, 304, Short.MAX_VALUE).addComponent((Component)this.textPort, -2, 71, -2)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.textPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textPort, -2, -1, -2)).addContainerGap(179, Short.MAX_VALUE)));
        this.tabbed.addTab(stringManager.getString("Settings"), this.jPanel1);
        this.jScrollPane2.setViewportView((Component)this.tableUsers);
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        GroupLayout panelUsersLayout = new GroupLayout(this.panelUsers);
        this.panelUsers.setLayout(panelUsersLayout);
        panelUsersLayout.setHorizontalGroup(panelUsersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUsersLayout.createSequentialGroup().addContainerGap().addGroup(panelUsersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 432, Short.MAX_VALUE).addGroup(panelUsersLayout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2))).addContainerGap()));
        panelUsersLayout.setVerticalGroup(panelUsersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelUsersLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 235, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelUsersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addContainerGap()));
        this.tabbed.addTab(stringManager.getString("Users"), this.panelUsers);
        this.textLog.setColumns(20);
        this.textLog.setEditable(false);
        this.textLog.setRows(5);
        this.textLog.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane1.setViewportView((Component)this.textLog);
        GroupLayout panelLogLayout = new GroupLayout(this.panelLog);
        this.panelLog.setLayout(panelLogLayout);
        panelLogLayout.setHorizontalGroup(panelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLogLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 432, Short.MAX_VALUE).addContainerGap()));
        panelLogLayout.setVerticalGroup(panelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLogLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 266, Short.MAX_VALUE).addContainerGap()));
        this.tabbed.addTab("Log", this.panelLog);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbed, GroupLayout.Alignment.LEADING, -1, 457, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbed, -1, 313, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmGetActionPerformed(ActionEvent evt) {
        this.getUserList();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        User user = UserEditDialog.showDialog(null);
        if (user != null) {
            this.newUser(user);
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        User user;
        if (this.tableUsers.getSelectedRow() >= 0 && (user = UserEditDialog.showDialog(this.userList.get(this.tableUsers.getSelectedRow()))) != null) {
            this.updateUser(user);
        }
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableUsers.getSelectedRow() >= 0 && MessageBox.show((Component)this, (String)stringManager.getString("Deletion"), (String)stringManager.getString("UserDelete.query_message"), (int[])ModalResult.YESNO, (int)3) == 5) {
            this.deleteUser(this.userList.get(this.tableUsers.getSelectedRow()));
        }
    }
}

