/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.mpak.orbada.jaybird.OrbadaJaybirdPlugin;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExplainPlanPanel
extends JPanel
implements Closeable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    private Database database;
    private JScrollPane jScrollPane1;
    private TextArea textPlan;

    public ExplainPlanPanel(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlan(String sqlText) {
        try {
            Query query = this.database.createQuery();
            query.setSqlText(sqlText);
            PreparedStatement statement = this.database.getConnection().prepareStatement(query.getPreparedSqlText());
            try {
                Method method = statement.getClass().getMethod("getExecutionPlan", null);
                if (method == null) {
                    this.textPlan.setText(stringManager.getString("ExplainPlanPanel.no_get_execution_plan_message"));
                } else {
                    this.textPlan.setText((String)method.invoke((Object)statement, (Object[])null));
                }
            }
            finally {
                statement.close();
            }
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.textPlan.setText(ex.getClass().getName() + "\n" + ex.getMessage());
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textPlan = new TextArea();
        this.setLayout(new BorderLayout());
        this.textPlan.setColumns(20);
        this.textPlan.setRows(5);
        this.textPlan.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane1.setViewportView((Component)this.textPlan);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

