/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.firebirdsql.management.FBBackupManager;
import pl.mpak.orbada.db.Schema;
import pl.mpak.orbada.gui.comps.util.SchemasComboBoxModel;
import pl.mpak.orbada.gui.comps.util.SchemasListCellRenderer;
import pl.mpak.orbada.jaybird.OrbadaJaybirdPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RestoreDatabaseDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    private Thread worker;
    private OutputStream logger;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkNoIndex;
    private JCheckBox checkNoShadow;
    private JCheckBox checkNoValid;
    private JCheckBox checkRestoreReplace;
    private Action cmClose;
    private Action cmRestore;
    private ComboBox comboPageSize;
    private ComboBox comboSchemas;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel panelLog;
    private JTabbedPane tabbed;
    private TextField textBackupDatabase;
    private TextField textDatabase;
    private TextField textHost;
    private TextArea textLog;
    private JPasswordField textPassword;
    private TextField textPort;
    private TextField textUser;

    public RestoreDatabaseDialog() {
        super(SwingUtil.getRootFrame(), true);
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RestoreDatabaseDialog dialog = new RestoreDatabaseDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.comboSchemas.setModel((ComboBoxModel)new SchemasComboBoxModel("Firebird"));
        this.comboSchemas.setRenderer((ListCellRenderer)new SchemasListCellRenderer());
        this.schemaChanged();
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void enableControls(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RestoreDatabaseDialog.this.comboSchemas.setEnabled(value);
                RestoreDatabaseDialog.this.textHost.setEnabled(value);
                RestoreDatabaseDialog.this.textUser.setEnabled(value);
                RestoreDatabaseDialog.this.textPassword.setEnabled(value);
                RestoreDatabaseDialog.this.textDatabase.setEnabled(value);
                RestoreDatabaseDialog.this.textPort.setEnabled(value);
                RestoreDatabaseDialog.this.textBackupDatabase.setEnabled(value);
                RestoreDatabaseDialog.this.cmRestore.setEnabled(value);
                RestoreDatabaseDialog.this.cmClose.setEnabled(value);
                RestoreDatabaseDialog.this.comboPageSize.setEnabled(value);
                RestoreDatabaseDialog.this.checkNoIndex.setEnabled(value);
                RestoreDatabaseDialog.this.checkNoShadow.setEnabled(value);
                RestoreDatabaseDialog.this.checkNoValid.setEnabled(value);
            }
        });
    }

    private OutputStream getLogger() {
        if (this.logger == null) {
            this.logger = new OutputStream(){
                final StringBuffer sb = new StringBuffer();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(int b) throws IOException {
                    StringBuffer stringBuffer = this.sb;
                    synchronized (stringBuffer) {
                        this.sb.append((char)b);
                    }
                    if (this.sb.length() > 10000) {
                        this.flush();
                    }
                }

                public void flush() throws IOException {
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            StringBuffer stringBuffer = sb;
                            synchronized (stringBuffer) {
                                RestoreDatabaseDialog.this.textLog.append(sb.toString());
                                sb.setLength(0);
                            }
                        }
                    });
                }
            };
        }
        return this.logger;
    }

    private void createBackupDatabase() {
        final FBBackupManager manager = new FBBackupManager();
        try {
            this.enableControls(false);
            this.textLog.setText("");
            manager.setHost(this.textHost.getText());
            manager.setUser(this.textUser.getText());
            manager.setPassword(new String(this.textPassword.getPassword()));
            manager.setPort(Integer.valueOf(this.textPort.getText()).intValue());
            manager.setDatabase(this.textDatabase.getText());
            manager.setBackupPath(this.textBackupDatabase.getText());
            manager.setVerbose(true);
            manager.setRestorePageSize(Integer.valueOf(this.comboPageSize.getText()).intValue());
            manager.setRestoreReplace(this.checkRestoreReplace.isSelected());
            int checks = 0;
            if (this.checkNoIndex.isSelected()) {
                checks |= 0x100;
            }
            if (this.checkNoShadow.isSelected()) {
                checks |= 0x200;
            }
            if (this.checkNoValid.isSelected()) {
                checks |= 0x400;
            }
            final int options = checks;
            manager.setLogger(this.getLogger());
            this.worker = new Thread("Restore Firbird Database"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        manager.restoreDatabase(options);
                    }
                    catch (SQLException ex) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                RestoreDatabaseDialog.this.textLog.append("\n" + ex.getMessage());
                            }
                        });
                    }
                    finally {
                        try {
                            RestoreDatabaseDialog.this.getLogger().flush();
                        }
                        catch (IOException iOException) {}
                        RestoreDatabaseDialog.this.enableControls(true);
                    }
                }
            };
            this.worker.start();
            this.tabbed.setSelectedComponent(this.panelLog);
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
            this.enableControls(true);
        }
    }

    private void schemaChanged() {
        if (this.comboSchemas.getSelectedItem() instanceof Schema) {
            Schema schema = (Schema)this.comboSchemas.getSelectedItem();
            this.textHost.setText(schema.getHost());
            this.textUser.setText(schema.getUser());
            this.textPassword.setText(schema.getPassword());
            this.textDatabase.setText(schema.getDatabaseName());
            if (schema.getPort() == null) {
                this.textPort.setText("3050");
            } else {
                this.textPort.setText(schema.getPort().toString());
            }
        } else {
            this.textHost.setText("");
            this.textUser.setText("SYSDBA");
            this.textPassword.setText("masterkey");
            this.textDatabase.setText("");
            this.textPort.setText("3050");
        }
    }

    private void initComponents() {
        this.cmRestore = new Action();
        this.cmClose = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.tabbed = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.comboSchemas = new ComboBox();
        this.jLabel2 = new JLabel();
        this.textHost = new TextField();
        this.jLabel3 = new JLabel();
        this.textUser = new TextField();
        this.jLabel4 = new JLabel();
        this.textPassword = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.textDatabase = new TextField();
        this.jLabel6 = new JLabel();
        this.textPort = new TextField();
        this.jLabel7 = new JLabel();
        this.textBackupDatabase = new TextField();
        this.checkNoIndex = new JCheckBox();
        this.checkNoValid = new JCheckBox();
        this.checkNoShadow = new JCheckBox();
        this.checkRestoreReplace = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.comboPageSize = new ComboBox();
        this.jLabel9 = new JLabel();
        this.panelLog = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textLog = new TextArea();
        this.cmRestore.setActionCommandKey("cmRestore");
        this.cmRestore.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmRestore.setText(stringManager.getString("cmRestore.text"));
        this.cmRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RestoreDatabaseDialog.this.cmRestoreActionPerformed(evt);
            }
        });
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose.text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RestoreDatabaseDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("RestoreDatabaseDialog.title"));
        this.buttonOk.setAction((javax.swing.Action)this.cmRestore);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.tabbed.setFocusable(false);
        this.jLabel1.setText(stringManager.getString("SelectSchemaForRestore"));
        this.comboSchemas.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RestoreDatabaseDialog.this.comboSchemasItemStateChanged(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("Host-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("User-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("Password-dd"));
        this.textPassword.setText("jPasswordField1");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(stringManager.getString("Database-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(stringManager.getString("Port-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(stringManager.getString("ArchiveName-dd"));
        this.checkNoIndex.setText(stringManager.getString("DeactivateIndexes"));
        this.checkNoValid.setText(stringManager.getString("NoValidateDatabase"));
        this.checkNoShadow.setText(stringManager.getString("NoShadow"));
        this.checkRestoreReplace.setSelected(true);
        this.checkRestoreReplace.setText(stringManager.getString("CreateNewDatabase"));
        this.checkRestoreReplace.setEnabled(false);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(stringManager.getString("PageSize-dd"));
        this.comboPageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"1024", "2048", "4096", "8192"}));
        this.jLabel9.setText(stringManager.getString("bytes"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1, -1, 515, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent((Component)this.comboSchemas, -1, 515, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, 130, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -1, 130, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING, -1, 130, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING, -1, 130, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -1, 130, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, 130, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -2, 130, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkNoIndex).addComponent(this.checkNoValid).addComponent(this.checkNoShadow).addComponent(this.checkRestoreReplace).addComponent((Component)this.textPort, -2, 85, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.textPassword, GroupLayout.Alignment.LEADING).addComponent((Component)this.textUser, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.textHost, GroupLayout.Alignment.LEADING, -1, 176, Short.MAX_VALUE)).addComponent((Component)this.textDatabase, -1, 381, Short.MAX_VALUE).addComponent((Component)this.textBackupDatabase, -1, 381, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.comboPageSize, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboSchemas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.textPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textDatabase, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.textBackupDatabase, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)this.comboPageSize, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNoIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNoValid).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNoShadow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkRestoreReplace).addContainerGap(34, Short.MAX_VALUE)));
        this.tabbed.addTab(stringManager.getString("Settings"), this.jPanel1);
        this.textLog.setColumns(20);
        this.textLog.setEditable(false);
        this.textLog.setRows(5);
        this.textLog.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane1.setViewportView((Component)this.textLog);
        GroupLayout panelLogLayout = new GroupLayout(this.panelLog);
        this.panelLog.setLayout(panelLogLayout);
        panelLogLayout.setHorizontalGroup(panelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLogLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 515, Short.MAX_VALUE).addContainerGap()));
        panelLogLayout.setVerticalGroup(panelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLogLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 343, Short.MAX_VALUE).addContainerGap()));
        this.tabbed.addTab(stringManager.getString("Log"), this.panelLog);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbed, GroupLayout.Alignment.LEADING, -1, 540, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbed, -1, 390, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmRestoreActionPerformed(ActionEvent evt) {
        this.createBackupDatabase();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void comboSchemasItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.schemaChanged();
        }
    }
}

