/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import org.firebirdsql.management.FBUser;
import org.firebirdsql.management.User;
import pl.mpak.orbada.jaybird.OrbadaJaybirdPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class UserEditDialog
extends JDialog {
    private User user;
    private int modalResult = 0;
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private TextField textFirstName;
    private TextField textId;
    private TextField textLastName;
    private TextField textMiddleName;
    private TextField textName;
    private JPasswordField textPassword;
    private JPasswordField textReenterPassword;

    public UserEditDialog(User user) {
        super(SwingUtil.getRootFrame(), true);
        this.user = user;
        this.initComponents();
        this.init();
    }

    public static User showDialog(User user) {
        UserEditDialog dialog = new UserEditDialog(user);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return dialog.user;
        }
        return null;
    }

    private void init() {
        if (this.user != null) {
            this.textName.setText(this.user.getUserName());
            this.textFirstName.setText(this.user.getFirstName());
            this.textMiddleName.setText(this.user.getMiddleName());
            this.textLastName.setText(this.user.getLastName());
            this.textId.setText(String.valueOf(this.user.getUserId()));
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jLabel1 = new JLabel();
        this.textId = new TextField();
        this.jLabel2 = new JLabel();
        this.textName = new TextField();
        this.jLabel3 = new JLabel();
        this.textFirstName = new TextField();
        this.textMiddleName = new TextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.textLastName = new TextField();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel6 = new JLabel();
        this.textPassword = new JPasswordField();
        this.jLabel7 = new JLabel();
        this.textReenterPassword = new JPasswordField();
        this.jLabel8 = new JLabel();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setText(stringManager.getString("cmOk.text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setText(stringManager.getString("cmCancel.text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("UserEditDialog.title"));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(stringManager.getString("UserId-dd"));
        this.textId.setEditable(false);
        this.textId.setFocusable(false);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("UserName-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("FirstName-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("SecondName-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(stringManager.getString("LastName-dd"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(stringManager.getString("Password-dd"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(stringManager.getString("ReenterPassword-dd"));
        this.jLabel8.setText(stringManager.getString("UserEditDialog-pass-info"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textId, -2, 69, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 233, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textFirstName, -1, 233, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textMiddleName, -1, 233, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textLastName, -1, 233, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPassword, -1, 233, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textReenterPassword, -1, 233, Short.MAX_VALUE)).addComponent(this.jLabel8, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textFirstName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textMiddleName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textLastName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.textPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.textReenterPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (StringUtil.isEmpty((String)this.textName.getText())) {
            MessageBox.show((Component)this, (String)stringManager.getString("Error"), (String)stringManager.getString("UserNameCantBeBlank"), (int)1, (int)0);
            return;
        }
        String password = new String(this.textPassword.getPassword());
        if (!password.equals(new String(this.textReenterPassword.getPassword()))) {
            MessageBox.show((Component)this, (String)stringManager.getString("Error"), (String)stringManager.getString("PasswordMustBeEqueals"), (int)1, (int)0);
            return;
        }
        if (this.user == null) {
            if (StringUtil.isEmpty((String)password)) {
                MessageBox.show((Component)this, (String)stringManager.getString("Error"), (String)stringManager.getString("NewUserRequiredPassword"), (int)1, (int)0);
                return;
            }
            this.user = new FBUser();
        }
        this.user.setUserName(this.textName.getText());
        this.user.setFirstName(this.textFirstName.getText());
        this.user.setMiddleName(this.textMiddleName.getText());
        this.user.setLastName(this.textLastName.getText());
        if (StringUtil.isEmpty((String)password)) {
            this.user.setPassword(null);
        } else {
            this.user.setPassword(password);
        }
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

