/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jaybird.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import pl.mpak.orbada.jaybird.OrbadaJaybirdPlugin;
import pl.mpak.orbada.jaybird.gui.ExplainPlanPanel;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class JaybirdExplainPlanService
extends UniversalActionProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJaybirdPlugin.class);
    private ISettings settings;

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        if ("Firebird".equals(database.getDriverType()) && "org.firebirdsql.jdbc.FBDriver".equals(database.getDriverClassName())) {
            this.setShortCut(69, 2);
            this.setText(stringManager.getString("explain_plan"));
            this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/explain_plan.gif"));
            this.setActionCommandKey("JaybirdExplainPlanProvider");
            this.addActionListener(this.createActionListener());
            this.settings = this.application.getSettings("orbada-firebird-settings");
            return true;
        }
        return false;
    }

    public boolean addToolButton() {
        return true;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return "Firebird Explain Plan Provider";
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String sqlCode = JaybirdExplainPlanService.this.accessibilities.getSyntaxEditor().getCurrentText();
                Component[] array = JaybirdExplainPlanService.this.accessibilities.getResultTabs(ExplainPlanPanel.class);
                if (array.length > 0 && !JaybirdExplainPlanService.this.settings.getValue("multi-explain-plan", Boolean.valueOf(false)).booleanValue()) {
                    ExplainPlanPanel panel = (ExplainPlanPanel)array[0];
                    panel.updatePlan(sqlCode);
                    JaybirdExplainPlanService.this.accessibilities.setSelectedTab((Component)panel);
                    JaybirdExplainPlanService.this.accessibilities.setTabTooltip((Component)panel, SQLUtil.createTooltipFromSql((String)sqlCode));
                } else {
                    ExplainPlanPanel panel = new ExplainPlanPanel(JaybirdExplainPlanService.this.accessibilities.getViewAccesibilities().getDatabase());
                    panel.updatePlan(sqlCode);
                    JaybirdExplainPlanService.this.accessibilities.addResultTab(JaybirdExplainPlanService.this.getText(), (JComponent)panel);
                    JaybirdExplainPlanService.this.accessibilities.setTabTooltip((Component)panel, SQLUtil.createTooltipFromSql((String)sqlCode));
                }
            }
        };
    }

    public String getGroupName() {
        return "Firebird";
    }
}

