/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.melddiff.services;

import java.awt.Component;
import javax.swing.Icon;
import pl.mpak.orbada.melddiff.OrbadaMeldDiffPlugin;
import pl.mpak.orbada.melddiff.gui.DiffViewPanel;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DiffViewService
extends ViewProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMeldDiffPlugin.class);
    private DiffViewPanel viewPanel;
    private String leftFileName;
    private String rightFileName;

    public DiffViewService() {
    }

    public DiffViewService(String leftFileName, String rightFileName) {
        this.leftFileName = leftFileName;
        this.rightFileName = rightFileName;
    }

    public Component createView(IViewAccesibilities accesibilities) {
        this.viewPanel = new DiffViewPanel(accesibilities);
        if (this.leftFileName != null && this.rightFileName != null) {
            this.viewPanel.getMeldPanel().openComparison(this.leftFileName, this.rightFileName);
        }
        return this.viewPanel;
    }

    public String getPublicName() {
        return this.stringManager.getString("DiffViewService-public-name");
    }

    public String getViewId() {
        return null;
    }

    public Icon getIcon() {
        return ImageManager.getImage((String)"/pl/mpak/res/icons/diff.gif");
    }

    public boolean isForDatabase(Database database) {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("DiffViewService-description");
    }

    public String getGroupName() {
        return "Orbada Tools";
    }
}

