/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.melddiff.services;

import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JMenu;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.melddiff.OrbadaMeldDiffPlugin;
import pl.mpak.orbada.melddiff.cm.LeftContentAction;
import pl.mpak.orbada.melddiff.cm.RightContentAction;
import pl.mpak.orbada.melddiff.services.DiffViewService;
import pl.mpak.orbada.plugins.providers.OrbadaSyntaxTextAreaProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.patt.Resolvers;

public class MeldSyntaxService
extends OrbadaSyntaxTextAreaProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMeldDiffPlugin.class);
    private JMenu menu;
    private static String leftContent;
    private static String rightContent;

    public String getDescription() {
        return this.stringManager.getString("MeldSyntaxService-description");
    }

    public String getGroupName() {
        return "Orbada Tools";
    }

    private static void checkFilledContents(PerspectivePanel panel) {
        if (leftContent != null && rightContent != null) {
            String tempDir = Resolvers.expand((String)"$(java.io.tmpdir)");
            try {
                FileOutputStream fos = new FileOutputStream(tempDir + "/ojmeld-left.txt");
                fos.write(leftContent.getBytes());
                fos.close();
                fos = new FileOutputStream(tempDir + "/ojmeld-right.txt");
                fos.write(rightContent.getBytes());
                fos.close();
                panel.getPerspectiveAccesibilities().createView((ViewProvider)new DiffViewService(tempDir + "/ojmeld-left.txt", tempDir + "/ojmeld-right.txt"));
                leftContent = null;
                rightContent = null;
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public static void setLeftContent(String text, PerspectivePanel panel) {
        leftContent = text;
        MeldSyntaxService.checkFilledContents(panel);
    }

    public static void setRightContent(String text, PerspectivePanel panel) {
        rightContent = text;
        MeldSyntaxService.checkFilledContents(panel);
    }

    public void setSyntaxTextArea(SyntaxTextArea syntaxTextArea) {
        super.setSyntaxTextArea(syntaxTextArea);
        if (syntaxTextArea instanceof SyntaxTextArea) {
            this.menu = new JMenu(this.stringManager.getString("MeldSyntaxService-menu-diff-content"));
            this.menu.add((Action)((Object)new LeftContentAction(syntaxTextArea)));
            this.menu.add((Action)((Object)new RightContentAction(syntaxTextArea)));
            syntaxTextArea.getEditorArea().getComponentPopupMenu().add(this.menu);
        }
    }
}

