/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataPage;
import org.h2.store.PageStore;

public class PageOutputStream
extends OutputStream {
    private PageStore store;
    private int parentPage;
    private int type;
    private int pageId;
    private int nextPage;
    private DataPage page;
    private int remaining;

    public PageOutputStream(PageStore pageStore, int n, int n2, int n3) {
        this.store = pageStore;
        this.parentPage = n;
        this.nextPage = n2;
        this.type = n3;
        this.page = pageStore.createDataPage();
        this.initPage();
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void initPage() {
        this.page.reset();
        this.page.writeInt(this.parentPage);
        this.page.writeByte((byte)this.type);
        this.page.writeInt(0);
        this.remaining = this.store.getPageSize() - this.page.length();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        while (n2 > this.remaining) {
            this.page.write(byArray, n, this.remaining);
            n += this.remaining;
            n2 -= this.remaining;
            this.parentPage = this.nextPage;
            this.pageId = this.nextPage;
            try {
                this.nextPage = this.store.allocatePage();
            }
            catch (SQLException sQLException) {
                throw Message.convertToIOException(sQLException);
            }
            this.page.setInt(5, this.nextPage);
            this.storePage();
            this.initPage();
        }
        this.page.write(byArray, n, n2);
        this.remaining -= n2;
    }

    private void storePage() throws IOException {
        try {
            this.store.writePage(this.pageId, this.page);
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
    }

    public void close() throws IOException {
        this.page.setPos(4);
        this.page.writeByte((byte)(this.type | 0x10));
        this.page.writeInt(this.store.getPageSize() - this.remaining - 9);
        this.pageId = this.nextPage;
        this.storePage();
        this.store = null;
    }

    public void flush() throws IOException {
    }
}

