/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.util.BitField;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;

public class Storage {
    public static final int ALLOCATE_POS = -1;
    private static final int FREE_LIST_SIZE = Math.max(1024, 256);
    private DiskFile file;
    private int recordCount;
    private RecordReader reader;
    private int freeCount;
    private IntArray freeList = new IntArray();
    private IntArray pages = new IntArray();
    private int id;
    private Database database;
    private DataPage dummy;
    private int pageCheckIndex;

    public Storage(Database database, DiskFile diskFile, RecordReader recordReader, int n) {
        this.database = database;
        this.file = diskFile;
        this.reader = recordReader;
        this.id = n;
        this.dummy = DataPage.create((DataHandler)database, 0);
    }

    public RecordReader getRecordReader() {
        return this.reader;
    }

    void incrementRecordCount() {
        ++this.recordCount;
    }

    public Record getRecord(Session session, int n) throws SQLException {
        return this.file.getRecord(session, n, this.reader, this.id);
    }

    public Record getRecordIfStored(Session session, int n) throws SQLException {
        return this.file.getRecordIfStored(session, n, this.reader, this.id);
    }

    public int getNext(Record record) {
        int n;
        int n2;
        int n3 = -1;
        if (record == null) {
            if (this.pages.size() == 0) {
                return -1;
            }
            n3 = 0;
            n2 = this.pages.get(0);
            n = n2 * 64;
        } else {
            int n4 = record.getBlockCount();
            n2 = this.file.getPage(record.getPos());
            n = record.getPos() + n4;
        }
        Database database = this.database;
        synchronized (database) {
            BitField bitField = this.file.getUsed();
            while (true) {
                int n5;
                if (n2 != (n5 = this.file.getPage(n))) {
                    n3 = n3 < 0 ? this.pages.findNextIndexSorted(n5) : ++n3;
                    if (n3 >= this.pages.size()) {
                        return -1;
                    }
                    n2 = this.pages.get(n3);
                    n = Math.max(n, 64 * n2);
                }
                if (bitField.get(n)) {
                    return n;
                }
                if (bitField.getLong(n) == 0L) {
                    n = MathUtils.roundUp(n + 1, 64);
                    continue;
                }
                ++n;
            }
        }
    }

    public void updateRecord(Session session, Record record) throws SQLException {
        record.setDeleted(false);
        this.file.updateRecord(session, record);
    }

    public void addRecord(Session session, Record record, int n) throws SQLException {
        record.setStorageId(this.id);
        int n2 = this.file.getRecordOverhead() + record.getByteCount(this.dummy);
        n2 = MathUtils.roundUp(n2, 128);
        record.setDeleted(false);
        int n3 = n2 / 128;
        if (n == -1) {
            n = this.allocate(n3);
        } else {
            this.file.setUsed(n, n3);
        }
        record.setPos(n);
        record.setBlockCount(n3);
        record.setChanged(true);
        ++this.recordCount;
        this.file.addRecord(session, record);
    }

    public void removeRecord(Session session, int n) throws SQLException {
        this.checkOnePage();
        Record record = this.getRecord(session, n);
        if (SysProperties.CHECK && record.getDeleted()) {
            Message.throwInternalError("duplicate delete " + n);
        }
        record.setDeleted(true);
        int n2 = record.getBlockCount();
        this.file.uncommittedDelete(session);
        this.free(n, n2);
        --this.recordCount;
        this.file.removeRecord(session, n, record, n2);
    }

    private void refillFreeList() {
        if (this.freeList.size() != 0 || this.freeCount == 0) {
            return;
        }
        BitField bitField = this.file.getUsed();
        for (int i = 0; i < this.pages.size(); ++i) {
            int n = this.pages.get(i);
            int n2 = 64 * n;
            for (int j = 0; j < 64; ++j) {
                if (!bitField.get(n2)) {
                    if (this.freeList.size() < FREE_LIST_SIZE) {
                        this.freeList.add(n2);
                    } else {
                        return;
                    }
                }
                ++n2;
            }
        }
        if (SysProperties.CHECK2 && this.freeCount > this.freeList.size()) {
            Message.throwInternalError("freeCount expected " + this.freeList.size() + ", got: " + this.freeCount);
        }
        this.freeCount = this.freeList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocate(int n) throws SQLException {
        this.refillFreeList();
        if (this.freeList.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                BitField bitField = this.file.getUsed();
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = 0;
                block3: for (int i = 0; i < this.freeList.size(); ++i) {
                    int n5;
                    int n6 = this.freeList.get(i);
                    if (n6 >= n3 && n6 <= n4) continue;
                    if (bitField.get(n6)) {
                        this.freeList.remove(i--);
                        continue;
                    }
                    n3 = n6;
                    for (n4 = n6 + n - 1; n4 >= n3; --n4) {
                        n5 = this.file.getPage(n4);
                        if (n5 != n2) {
                            if (this.file.getPageOwner(n5) != this.id) continue block3;
                            n2 = n5;
                        }
                        if (bitField.get(n4)) continue block3;
                    }
                    n5 = n6;
                    this.freeList.remove(i);
                    this.file.setUsed(n5, n);
                    this.freeCount -= n;
                    return n5;
                }
            }
        }
        int n7 = this.file.allocate(this, n);
        this.file.setUsed(n7, n);
        this.freeCount -= n;
        return n7;
    }

    void free(int n, int n2) {
        this.file.free(n, n2);
        if (this.freeList.size() < FREE_LIST_SIZE) {
            this.freeList.add(n);
        }
        this.freeCount += n2;
    }

    public int getId() {
        return this.id;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void truncate(Session session) throws SQLException {
        this.freeList = new IntArray();
        this.freeCount = 0;
        this.recordCount = 0;
        this.file.truncateStorage(session, this, this.pages);
    }

    public void setReader(RecordReader recordReader) {
        this.reader = recordReader;
    }

    public void flushRecord(Record record) throws SQLException {
        this.file.writeBack(record);
    }

    public int getRecordOverhead() {
        return this.file.getRecordOverhead();
    }

    public DiskFile getDiskFile() {
        return this.file;
    }

    public void setRecordCount(int n) {
        this.recordCount = n;
    }

    void addPage(int n) {
        this.pages.addValueSorted(n);
    }

    void removePages(IntArray intArray) {
        this.pages.removeAllSorted(intArray);
    }

    void removePage(int n) {
        int n2 = this.pages.findIndexSorted(n);
        if (n2 != -1) {
            this.pages.remove(n2);
        }
    }

    private void checkOnePage() throws SQLException {
        this.pageCheckIndex = (this.pageCheckIndex + 1) % this.pages.size();
        int n = this.pages.get(this.pageCheckIndex);
        if (this.file.isPageFree(n) && this.file.getPageOwner(n) == this.id) {
            this.file.freePage(n);
        }
    }
}

