/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemSplit;
import org.h2.util.FileUtils;

public class FileObjectSplit
implements FileObject {
    private final String name;
    private final String mode;
    private final long maxLength;
    private FileObject[] list;
    private long filePointer;
    private long length;

    FileObjectSplit(String string, String string2, FileObject[] fileObjectArray, long l, long l2) {
        this.name = string;
        this.mode = string2;
        this.list = fileObjectArray;
        this.length = l;
        this.maxLength = l2;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].close();
        }
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public long length() throws IOException {
        return this.length;
    }

    private int read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.filePointer % this.maxLength;
        int n3 = (int)Math.min((long)n2, this.maxLength - l);
        FileObject fileObject = this.getFileObject();
        fileObject.seek(l);
        fileObject.readFully(byArray, n, n3);
        this.filePointer += (long)n3;
        return n3;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while ((n2 -= (n3 = this.read(byArray, n, n2))) > 0) {
            n += n3;
        }
        return;
    }

    public void seek(long l) throws IOException {
        this.filePointer = l;
    }

    private FileObject getFileObject() throws IOException {
        int n = (int)(this.filePointer / this.maxLength);
        while (n >= this.list.length) {
            int n2 = this.list.length;
            FileObject[] fileObjectArray = new FileObject[n2 + 1];
            System.arraycopy(this.list, 0, fileObjectArray, 0, n2);
            String string = FileSystemSplit.getFileName(this.name, n2);
            fileObjectArray[n2] = FileSystem.getInstance(string).openFileObject(string, this.mode);
            this.list = fileObjectArray;
        }
        return this.list[n];
    }

    public void setFileLength(long l) throws IOException {
        this.filePointer = Math.min(this.filePointer, l);
        int n = 1 + (int)(l / this.maxLength);
        if (n == this.list.length) {
            long l2 = l - this.maxLength * (long)(n - 1);
            this.list[this.list.length - 1].setFileLength(l2);
        } else {
            FileObject[] fileObjectArray = new FileObject[n];
            int n2 = Math.max(n, this.list.length);
            long l3 = l;
            for (int i = 0; i < n2; ++i) {
                Object object;
                long l4 = Math.min(l3, this.maxLength);
                l3 -= l4;
                if (i >= n) {
                    this.list[i].close();
                    try {
                        FileUtils.delete(this.list[i].getName());
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw Message.convertToIOException(sQLException);
                    }
                }
                if (i >= this.list.length) {
                    object = FileSystemSplit.getFileName(this.name, i);
                    FileObject fileObject = FileSystem.getInstance((String)object).openFileObject((String)object, this.mode);
                    fileObject.setFileLength(l4);
                    fileObjectArray[i] = fileObject;
                    continue;
                }
                object = this.list[i];
                if (object.length() != l4) {
                    object.setFileLength(l4);
                }
                fileObjectArray[i] = this.list[i];
            }
            this.list = fileObjectArray;
        }
        this.length = l;
    }

    public void sync() throws IOException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].sync();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while ((n2 -= (n3 = this.writePart(byArray, n, n2))) > 0) {
            n += n3;
        }
        return;
    }

    private int writePart(byte[] byArray, int n, int n2) throws IOException {
        long l = this.filePointer % this.maxLength;
        int n3 = (int)Math.min((long)n2, this.maxLength - l);
        FileObject fileObject = this.getFileObject();
        fileObject.seek(l);
        fileObject.write(byArray, n, n3);
        this.filePointer += (long)n3;
        this.length = Math.max(this.length, this.filePointer);
        return n3;
    }

    public String getName() {
        return this.name;
    }
}

