/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.hsqldb.services.HSqlDbAliasesView;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.hsqldb.services.HSqlDbPerspectiveProvider;
import pl.mpak.orbada.hsqldb.services.HSqlDbProceduresView;
import pl.mpak.orbada.hsqldb.services.HSqlDbSequencesView;
import pl.mpak.orbada.hsqldb.services.HSqlDbTablesView;
import pl.mpak.orbada.hsqldb.services.HSqlDbTriggersView;
import pl.mpak.orbada.hsqldb.services.HSqlDbViewsView;
import pl.mpak.orbada.hsqldb.services.HsqlDbDatabaseProvider;
import pl.mpak.orbada.hsqldb.services.HsqlDbSessionsView;
import pl.mpak.orbada.hsqldb.services.UniversalColumnProvider;
import pl.mpak.orbada.hsqldb.services.UniversalExplainPlanProvider;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

public class OrbadaHSqlDbPlugin
extends OrbadaPlugin {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    public static final String hsqlDbDriverType = "HSQLDB";
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;
    public static final String hsqlDb20 = "HSQLDB2.0+";
    public static final String hsqlDb18 = "HSQLDB1.8+";

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-hsqldb-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaHSqlDbPlugin";
    }

    public String getDescriptiveName() {
        return String.format(this.stringManager.getString("OrbadaHSqlDbPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,HSQLDB";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 2, 8).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-hsqldb-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(hsqlDbDriverType);
        classList.add(HSqlDbInfoProvider.class);
        classList.add(HSqlDbTablesView.class);
        classList.add(HSqlDbViewsView.class);
        classList.add(HSqlDbTriggersView.class);
        classList.add(HSqlDbAliasesView.class);
        classList.add(HSqlDbPerspectiveProvider.class);
        classList.add(HSqlDbSequencesView.class);
        classList.add(HSqlDbProceduresView.class);
        classList.add(HsqlDbSessionsView.class);
        classList.add(HsqlDbDatabaseProvider.class);
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(UniversalColumnProvider.class);
            classList.add(UniversalExplainPlanProvider.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    static {
        classList = new ArrayList();
    }
}

