/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.dbinfo;

import pl.mpak.orbada.hsqldb.dbinfo.HSqlDbSchemaListInfo;
import pl.mpak.orbada.hsqldb.dbinfo.HSqlDbTableTypeListInfo;
import pl.mpak.orbada.hsqldb.dbinfo.HSqlDbTypeListInfo;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class HSqlDatabaseInfo
extends DbDatabaseInfo {
    public HSqlDatabaseInfo(Database database) {
        super(database);
        try {
            this.refresh();
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public String[] getMemberNames() {
        return new String[]{"Version", "Banner"};
    }

    public Variant[] getMemberValues() {
        return new Variant[]{new Variant(this.getVersion()), new Variant(this.getBanner())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            this.setVersion(this.getDatabase().getMetaData().getDatabaseProductVersion());
            this.setBanner("Database: " + this.getDatabase().getMetaData().getDatabaseProductName() + ", " + this.getDatabase().getMetaData().getDatabaseProductVersion() + "\n" + "Driver: " + this.getDatabase().getMetaData().getDriverName() + ", " + this.getDatabase().getMetaData().getDriverVersion());
            this.setRemarks(this.getBanner());
            this.put((DbObjectIdentified)new HSqlDbSchemaListInfo(this));
            this.put((DbObjectIdentified)new HSqlDbTableTypeListInfo(this));
            this.put((DbObjectIdentified)new HSqlDbTypeListInfo(this));
        }
        finally {
            this.setRefreshed(true);
        }
    }

    public String getDescription() {
        return "HSQLDB Database Info Provider";
    }
}

