/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.gui.aliases.AliasesPanelView;
import pl.mpak.orbada.hsqldb.gui.seqs.SequencesPanelView;
import pl.mpak.orbada.hsqldb.gui.tables.TablesPanelView;
import pl.mpak.orbada.hsqldb.gui.views.ViewsPanelView;
import pl.mpak.orbada.hsqldb.services.HSqlDbAliasesView;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.hsqldb.services.HSqlDbSequencesView;
import pl.mpak.orbada.hsqldb.services.HSqlDbTablesView;
import pl.mpak.orbada.hsqldb.services.HSqlDbViewsView;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class HSqlDbSearchObjectDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IPerspectiveAccesibilities accesibilities;
    private int modalResult = 1;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmGoto;
    private Action cmSearch;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableObjects;
    private TextField textSearch;

    public HSqlDbSearchObjectDialog(IPerspectiveAccesibilities accesibilities) {
        super(SwingUtil.getRootFrame());
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    public static void showDialog(IPerspectiveAccesibilities accesibilities) {
        HSqlDbSearchObjectDialog dialog = new HSqlDbSearchObjectDialog(accesibilities);
        dialog.setVisible(true);
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        SwingUtil.addAction((JDialog)this, (String)this.cmSearch.getActionCommandKey(), (javax.swing.Action)this.cmSearch);
        this.textSearch.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.tableObjects));
        this.tableObjects.getQuery().setDatabase(this.accesibilities.getDatabase());
        try {
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("schema_name", this.stringManager.getString("schema"), 130));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("table_schema", this.stringManager.getString("table-schema"), 130));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 130));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("sub_type", this.stringManager.getString("info"), 200));
            this.tableObjects.getQuery().setSqlText(Sql.getObjectsSearch("object_type not in ('FUNCTION', 'PROCEDURE')", HSqlDbInfoProvider.getVersionTest(this.accesibilities.getDatabase())));
        }
        catch (UseDBException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HSqlDbSearchObjectDialog.this.textSearch.requestFocusInWindow();
            }
        });
    }

    @Override
    public void dispose() {
        this.tableObjects.getQuery().close();
        super.dispose();
    }

    private void initComponents() {
        this.cmSearch = new Action();
        this.cmCancel = new Action();
        this.cmGoto = new Action();
        this.jLabel1 = new JLabel();
        this.textSearch = new TextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableObjects = new ViewTable();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmSearch.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_object16.gif"));
        this.cmSearch.setTooltip(this.stringManager.getString("HSqlDbSearchObjectDialog-cmSearch-hint"));
        this.cmSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HSqlDbSearchObjectDialog.this.cmSearchActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HSqlDbSearchObjectDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmGoto.setActionCommandKey("cmGoto");
        this.cmGoto.setEnabled(false);
        this.cmGoto.setText(this.stringManager.getString("cmGoto-text"));
        this.cmGoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HSqlDbSearchObjectDialog.this.cmGotoActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("HSqlDbSearchObjectDialog-title"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HSqlDbSearchObjectDialog.this.formWindowClosing(evt);
            }
        });
        this.jLabel1.setText(this.stringManager.getString("object-name-dd"));
        this.jButton1.setAction((javax.swing.Action)this.cmSearch);
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jScrollPane1.setViewportView((Component)this.tableObjects);
        this.buttonOk.setAction((javax.swing.Action)this.cmGoto);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 677, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSearch, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jLabel1).addComponent((Component)this.textSearch, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 216, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.tableObjects.getQuery().close();
    }

    private void cmSearchActionPerformed(ActionEvent evt) {
        if (!"".equals(this.textSearch.getText())) {
            try {
                this.tableObjects.getQuery().close();
                this.tableObjects.getQuery().paramByName("object_name").setString(this.textSearch.getText());
                this.tableObjects.getQuery().open();
                this.cmGoto.setEnabled(!this.tableObjects.getQuery().eof());
                if (!this.tableObjects.getQuery().eof()) {
                    this.tableObjects.changeSelection(0, this.tableObjects.getSelectedColumn());
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmGotoActionPerformed(ActionEvent evt) {
        try {
            this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
            final String schemaName = this.tableObjects.getQuery().fieldByName("schema_name").getString();
            final String objectName = this.tableObjects.getQuery().fieldByName("object_name").getString();
            String schemaType = this.tableObjects.getQuery().fieldByName("object_type").getString();
            final String tableSchema = this.tableObjects.getQuery().fieldByName("table_schema").getString();
            final String tableName = this.tableObjects.getQuery().fieldByName("table_name").getString();
            if ("TABLE".equals(schemaType)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSqlDbTablesView[] views = (HSqlDbTablesView[])HSqlDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(HSqlDbTablesView.class);
                        if (views != null && views.length > 0) {
                            TablesPanelView c = (TablesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)views[0]);
                            if (c == null) {
                                c = (TablesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)views[0]);
                            }
                            c.setCurrentSchemaName(schemaName);
                            c.refresh(objectName);
                            HSqlDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)c);
                        }
                    }
                });
            } else if ("INDEX".equals(schemaType) || "TRIGGER".equals(schemaType)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSqlDbTablesView[] tables = (HSqlDbTablesView[])HSqlDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(HSqlDbTablesView.class);
                        if (tables != null && tables.length > 0) {
                            TablesPanelView c = (TablesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)tables[0]);
                            if (c == null) {
                                c = (TablesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)tables[0]);
                            }
                            c.setCurrentSchemaName(tableSchema);
                            c.refresh(tableName);
                            HSqlDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)c);
                        }
                    }
                });
            } else if ("VIEW".equals(schemaType)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSqlDbViewsView[] tables = (HSqlDbViewsView[])HSqlDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(HSqlDbViewsView.class);
                        if (tables != null && tables.length > 0) {
                            ViewsPanelView c = (ViewsPanelView)HSqlDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)tables[0]);
                            if (c == null) {
                                c = (ViewsPanelView)HSqlDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)tables[0]);
                            }
                            c.setCurrentSchemaName(schemaName);
                            c.refresh(objectName);
                            HSqlDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)c);
                        }
                    }
                });
            } else if ("DOMAIN".equals(schemaType) || "ALIAS".equals(schemaType)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSqlDbAliasesView[] procs = (HSqlDbAliasesView[])HSqlDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(HSqlDbAliasesView.class);
                        if (procs != null && procs.length > 0) {
                            AliasesPanelView c = (AliasesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)procs[0]);
                            if (c == null) {
                                c = (AliasesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)procs[0]);
                            }
                            c.setCurrentSchemaName(schemaName);
                            c.refresh(objectName);
                            HSqlDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)c);
                        }
                    }
                });
            } else if ("SEQUENCE".equals(schemaType)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSqlDbSequencesView[] procs = (HSqlDbSequencesView[])HSqlDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(HSqlDbSequencesView.class);
                        if (procs != null && procs.length > 0) {
                            SequencesPanelView c = (SequencesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)procs[0]);
                            if (c == null) {
                                c = (SequencesPanelView)HSqlDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)procs[0]);
                            }
                            c.setCurrentSchemaName(schemaName);
                            c.refresh(objectName);
                            HSqlDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)c);
                        }
                    }
                });
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

