/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.aliases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.cm.CreateAliasWizardAction;
import pl.mpak.orbada.hsqldb.cm.GrantClassWizardAction;
import pl.mpak.orbada.hsqldb.cm.RevokeClassWizardAction;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class AliasesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonDropTrigger;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmDropAlias;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JToolBar.Separator separator;
    private QueryTableStatusBar statusBarTriggers;
    private ViewTable tablealiasses;
    private JToolBar toolBar;

    public AliasesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = HSqlDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.toolBar.add((Component)new ToolButton((javax.swing.Action)((Object)new CreateAliasWizardAction(this.getDatabase()){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                AliasesPanelView.this.refresh();
            }
        })));
        this.toolBar.add((Component)new ToolButton((javax.swing.Action)((Object)new GrantClassWizardAction(this.getDatabase()){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                AliasesPanelView.this.refresh();
            }
        })));
        this.toolBar.add((Component)new ToolButton((javax.swing.Action)((Object)new RevokeClassWizardAction(this.getDatabase()){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                AliasesPanelView.this.refresh();
            }
        })));
        this.tablealiasses.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = AliasesPanelView.this.tablealiasses.getSelectedRow();
                if (rowIndex >= 0 && AliasesPanelView.this.tablealiasses.getQuery().isActive()) {
                    try {
                        AliasesPanelView.this.tablealiasses.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tablealiasses.getQuery().setDatabase(this.getDatabase());
        try {
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("alias_name", this.stringManager.getString("alias-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("object_name", this.stringManager.getString("specification"), 200));
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("num_input_params", this.stringManager.getString("num-input-parameters"), 30));
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("num_result_sets", this.stringManager.getString("num-result-sets"), 30));
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("alias_type", this.stringManager.getString("alias-type"), 70));
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("procedure_type", this.stringManager.getString("procedure-type"), 70));
            this.tablealiasses.addColumn((TableColumn)new QueryTableColumn("remarks", this.stringManager.getString("comment"), 350));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("alias_name", this.stringManager.getString("alias-name"), (String[])null));
            def.add(new SqlFilterDefComponent("ifnull(p.specific_name, a.object_name)", this.stringManager.getString("specification"), (String[])null));
            def.add(new SqlFilterDefComponent("alias_type", this.stringManager.getString("alias-type"), (String[])null));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-aliases-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tablealiasses, (JButton)this.buttonActions, this.menuActions, "hsqldb-aliasses-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(HSqlDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String aliasName = null;
            if (this.tablealiasses.getQuery().isActive() && this.tablealiasses.getSelectedRow() >= 0) {
                this.tablealiasses.getQuery().getRecord(this.tablealiasses.getSelectedRow());
                aliasName = this.tablealiasses.getQuery().fieldByName("ALIAS_NAME").getString();
            }
            this.refresh(aliasName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int index = Math.max(0, this.tablealiasses.getSelectedRow());
            this.tablealiasses.getQuery().close();
            this.tablealiasses.getQuery().setSqlText(Sql.getAliasList(this.filter.getSqlText()));
            this.tablealiasses.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tablealiasses.getQuery().open();
            if (objectName != null && this.tablealiasses.getQuery().locate("ALIAS_NAME", new Variant(objectName))) {
                this.tablealiasses.changeSelection(this.tablealiasses.getQuery().getCurrentRecord().getIndex(), this.tablealiasses.getSelectedColumn());
            } else if (!this.tablealiasses.getQuery().isEmpty()) {
                this.tablealiasses.changeSelection(Math.min(index, this.tablealiasses.getRowCount() - 1), this.tablealiasses.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tablealiasses.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropAlias = new Action();
        this.cmSelectSchema = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tablealiasses = new ViewTable();
        this.statusBarTriggers = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonDropTrigger = new ToolButton();
        this.separator = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropAlias.setActionCommandKey("cmDropTrigger");
        this.cmDropAlias.setEnabled(false);
        this.cmDropAlias.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropAlias.setText(this.stringManager.getString("cmDropAlias-text"));
        this.cmDropAlias.setTooltip(this.stringManager.getString("cmDropAlias-hint"));
        this.cmDropAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasesPanelView.this.cmDropAliasActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                AliasesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tablealiasses);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarTriggers.setShowFieldType(false);
        this.statusBarTriggers.setShowOpenTime(false);
        this.statusBarTriggers.setTable((QueryTable)this.tablealiasses);
        this.jPanel1.add((Component)this.statusBarTriggers, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBar.add(this.jSeparator2);
        this.buttonDropTrigger.setAction((javax.swing.Action)this.cmDropAlias);
        this.buttonDropTrigger.setHorizontalTextPosition(0);
        this.buttonDropTrigger.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonDropTrigger);
        this.toolBar.add(this.separator);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmDropAliasActionPerformed(ActionEvent evt) {
        if (this.tablealiasses.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tablealiasses.getQuery().getRecord(this.tablealiasses.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tablealiasses.getQuery().fieldByName("alias_name").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("AliasesPanelView-drop-selected-alias-q"), objectName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop alias " + objectName, true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tablealiasses.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    AliasesPanelView.this.setCurrentSchemaName(o.toString());
                    AliasesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }
}

