/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.aliases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class ProcedureParametersPanel
extends JPanel
implements ITabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private Timer timer;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private QueryTableStatusBar statusBar;
    private ViewTable tableParameters;
    private JToolBar toolBar;

    public ProcedureParametersPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                ProcedureParametersPanel.this.refresh();
            }
        };
        OrbadaHSqlDbPlugin.getRefreshQueue().add(this.timer);
        this.tableParameters.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = ProcedureParametersPanel.this.tableParameters.getSelectedRow();
                if (rowIndex >= 0 && ProcedureParametersPanel.this.tableParameters.getQuery().isActive()) {
                    try {
                        ProcedureParametersPanel.this.tableParameters.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableParameters.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("display_type", this.stringManager.getString("display-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("nullable", "Null?", 40));
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("column_type", this.stringManager.getString("column-type"), 50));
            this.tableParameters.addColumn((TableColumn)new QueryTableColumn("remarks", this.stringManager.getString("comment"), 300));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return this.stringManager.getString("ProcedureParametersPanel-title");
    }

    public void refresh() {
        try {
            String columnName = null;
            this.requestRefresh = false;
            if (this.tableParameters.getQuery().isActive() && this.tableParameters.getSelectedRow() >= 0) {
                this.tableParameters.getQuery().getRecord(this.tableParameters.getSelectedRow());
                columnName = this.tableParameters.getQuery().fieldByName("COLUMN_NAME").getString();
            }
            this.tableParameters.getQuery().close();
            this.tableParameters.getQuery().setSqlText(Sql.getProcedureParameterList(null));
            this.tableParameters.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableParameters.getQuery().paramByName("procedure_name").setString(this.currentTableName);
            this.tableParameters.getQuery().open();
            if (!this.tableParameters.getQuery().isEmpty()) {
                if (columnName != null && this.tableParameters.getQuery().locate("column_name", new Variant(columnName))) {
                    this.tableParameters.changeSelection(this.tableParameters.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableParameters.changeSelection(0, 0);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableParameters.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableParameters = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ProcedureParametersPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableParameters);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableParameters);
        this.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.jPanel1.add(this.toolBar);
        this.add((Component)this.jPanel1, "North");
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }
}

