/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.aliases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.cm.GrantClassWizardAction;
import pl.mpak.orbada.hsqldb.cm.RevokeClassWizardAction;
import pl.mpak.orbada.hsqldb.gui.aliases.ProcedureParametersPanel;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;
import pl.mpak.util.variant.Variant;

public class ProceduresPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu menuActions;
    private JPanel panelProcedures;
    private JSplitPane splinPane;
    private QueryTableStatusBar statusBar;
    private JTabbedPane tabbedTableInfo;
    private ViewTable tableProcedures;
    private JToolBar toolBar;

    public ProceduresPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = HSqlDbInfoProvider.getCurrentSchema(this.getDatabase());
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
            this.toolBar.add((Component)new ToolButton((javax.swing.Action)((Object)new GrantClassWizardAction(this.getDatabase()){

                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    ProceduresPanelView.this.refresh();
                }
            })));
            this.toolBar.add((Component)new ToolButton((javax.swing.Action)((Object)new RevokeClassWizardAction(this.getDatabase()){

                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    ProceduresPanelView.this.refresh();
                }
            })));
        }
        this.tableProcedures.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String procedureName = "";
                int rowIndex = ProceduresPanelView.this.tableProcedures.getSelectedRow();
                if (rowIndex >= 0 && ProceduresPanelView.this.tableProcedures.getQuery().isActive()) {
                    try {
                        ProceduresPanelView.this.tableProcedures.getQuery().getRecord(rowIndex);
                        procedureName = ProceduresPanelView.this.tableProcedures.getQuery().fieldByName("procedure_name").getString();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
                for (int i = 0; i < ProceduresPanelView.this.tabbedTableInfo.getTabCount(); ++i) {
                    Component c = ProceduresPanelView.this.tabbedTableInfo.getComponentAt(i);
                    if (!(c instanceof ITabObjectInfo)) continue;
                    ((ITabObjectInfo)c).refresh(null, ProceduresPanelView.this.currentSchemaName, procedureName);
                }
            }
        });
        this.addInfoPanel(new ProcedureParametersPanel(this.accesibilities));
        this.tableProcedures.getQuery().setDatabase(this.getDatabase());
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("procedure_name", this.stringManager.getString("procedure-name"), 220, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("procedure_type", this.stringManager.getString("procedure-type"), 80));
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("origin", this.stringManager.getString("origin"), 130));
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("num_input_params", this.stringManager.getString("num-input-params"), 60));
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
            this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("num_result_sets", this.stringManager.getString("num-result-sets"), 60));
        }
        this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("remarks", this.stringManager.getString("comment"), 300));
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
            this.tableProcedures.addColumn((TableColumn)new QueryTableColumn("specific_name", this.stringManager.getString("specification"), 200));
        }
        SqlFilterDef def = new SqlFilterDef();
        def.add(new SqlFilterDefComponent("procedure_name", this.stringManager.getString("procedure-name"), (String[])null));
        def.add(new SqlFilterDefComponent("procedure_type", this.stringManager.getString("procedure-type"), new String[]{"'PROCEDURE'", "'FUNCTION'"}));
        def.add(new SqlFilterDefComponent("origin", this.stringManager.getString("origin"), new String[]{"'ALIAS'", "'BUILTIN ROUTINE'", "'USER DEFINED ROUTINE'"}));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "hsqldb-procedures-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProceduresPanelView.this.tableProcedures.requestFocusInWindow();
            }
        });
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableProcedures, (JButton)this.buttonActions, this.menuActions, "hsqldb-procedures-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(HSqlDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String tableName = null;
            if (this.tableProcedures.getQuery().isActive() && this.tableProcedures.getSelectedRow() >= 0) {
                this.tableProcedures.getQuery().getRecord(this.tableProcedures.getSelectedRow());
                tableName = this.tableProcedures.getQuery().fieldByName("PROCEDURE_NAME").getString();
            }
            this.refresh(tableName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int index = Math.max(0, this.tableProcedures.getSelectedRow());
            this.tableProcedures.getQuery().close();
            this.tableProcedures.getQuery().setSqlText(Sql.getProcedureList(this.filter.getSqlText(), HSqlDbInfoProvider.getVersionTest(this.getDatabase())));
            this.tableProcedures.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableProcedures.getQuery().open();
            if (objectName != null && this.tableProcedures.getQuery().locate("PROCEDURE_NAME", new Variant(objectName))) {
                this.tableProcedures.changeSelection(this.tableProcedures.getQuery().getCurrentRecord().getIndex(), this.tableProcedures.getSelectedColumn());
            } else if (!this.tableProcedures.getQuery().isEmpty()) {
                this.tableProcedures.changeSelection(Math.min(index, this.tableProcedures.getRowCount() - 1), this.tableProcedures.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void addInfoPanel(JPanel panel) {
        this.tabbedTableInfo.addTab(((Titleable)panel).getTitle(), panel);
        this.tabbedTableInfo.setTabComponentAt(this.tabbedTableInfo.indexOfComponent(panel), (Component)new TabCloseComponent(((Titleable)panel).getTitle()));
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        int i = 0;
        while (i < this.tabbedTableInfo.getTabCount()) {
            Component c = this.tabbedTableInfo.getComponentAt(i);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++i;
            }
            this.tabbedTableInfo.remove(c);
        }
        this.tableProcedures.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.splinPane = new JSplitPane();
        this.panelProcedures = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableProcedures = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonActions = new ToolButton();
        this.tabbedTableInfo = new JTabbedPane();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProceduresPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ProceduresPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.splinPane.setBorder(null);
        this.splinPane.setDividerLocation(400);
        this.splinPane.setOrientation(0);
        this.splinPane.setContinuousLayout(true);
        this.splinPane.setOneTouchExpandable(true);
        this.panelProcedures.setPreferredSize(new Dimension(250, 100));
        this.panelProcedures.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableProcedures);
        this.panelProcedures.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowFieldValue(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableProcedures);
        this.panelProcedures.add((Component)this.statusBar, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBar);
        this.panelProcedures.add((Component)this.jPanel1, "North");
        this.splinPane.setLeftComponent(this.panelProcedures);
        this.tabbedTableInfo.setFocusable(false);
        this.splinPane.setRightComponent(this.tabbedTableInfo);
        this.add((Component)this.splinPane, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableProcedures.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    ProceduresPanelView.this.setCurrentSchemaName(o.toString());
                    ProceduresPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

