/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.dba;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionsPanelView
extends UniversalViewTabs {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private RefreshPanel refreshPanel;

    public SessionsPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.refreshPanel = new RefreshPanel();
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent e) {
                SessionsPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.refreshPanel);
        super.init();
    }

    public void close() throws IOException {
        this.refreshPanel.cancel();
        super.close();
    }

    public OrbadaTabbedPane getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return null;
    }

    public String getPanelName() {
        return "hsqldb-sessions-view";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "SESSION_ID";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        ArrayList<QueryTableColumn> columns = new ArrayList<QueryTableColumn>();
        QueryTableCellRenderer renderer = new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                int version = HSqlDbInfoProvider.getVersionTest(SessionsPanelView.this.getDatabase());
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    try {
                        if (!(version < 200 || StringUtil.isEmpty((String)SessionsPanelView.this.getQuery().fieldByName("WAITING_FOR_THIS").getString()) && StringUtil.isEmpty((String)SessionsPanelView.this.getQuery().fieldByName("THIS_WAITING_FOR").getString()))) {
                            label.setBackground(new Color(251, 121, 121));
                        } else if (StringUtil.equals((String)SessionsPanelView.this.getQuery().fieldByName("THIS_SESSION").getString(), (String)"T")) {
                            label.setBackground(new Color(180, 205, 240));
                        }
                    }
                    catch (Exception ex) {
                        label.setText(label.getText() + " [" + ex.getMessage() + "]");
                    }
                }
                return label;
            }
        };
        columns.add(new QueryTableColumn("SESSION_ID", this.stringManager.getString("session-id"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("CONNECTED", this.stringManager.getString("connected"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("USER_NAME", this.stringManager.getString("user-name"), 100, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("IS_ADMIN", this.stringManager.getString("is-admin"), 60, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("AUTOCOMMIT", this.stringManager.getString("auto-commit"), 60, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("READONLY", this.stringManager.getString("read-only"), 60, (TableCellRenderer)renderer));
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) == 108) {
            columns.add(new QueryTableColumn("MAXROWS", this.stringManager.getString("max-rows"), 70, (TableCellRenderer)renderer));
        }
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) >= 200) {
            columns.add(new QueryTableColumn("TRANSACTION", this.stringManager.getString("transaction"), 60, (TableCellRenderer)renderer));
            columns.add(new QueryTableColumn("WAITING_FOR_THIS", this.stringManager.getString("waiting-for-this"), 50, (TableCellRenderer)renderer));
        }
        columns.add(new QueryTableColumn("LAST_IDENTITY", this.stringManager.getString("last-identity"), 70, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("TRANSACTION_SIZE", this.stringManager.getString("transaction-size"), 70, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("SCHEMA", this.stringManager.getString("schema"), 100, (TableCellRenderer)renderer));
        if (HSqlDbInfoProvider.getVersionTest(this.getDatabase()) >= 200) {
            columns.add(new QueryTableColumn("CURRENT_STATEMENT", this.stringManager.getString("current-statement"), 250, (TableCellRenderer)renderer));
        }
        return columns.toArray(new QueryTableColumn[columns.size()]);
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionList(filter.getSqlText(), HSqlDbInfoProvider.getVersionTest(this.getDatabase()));
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("USER_NAME", this.stringManager.getString("user-name"), (String[])null), new SqlFilterDefComponent("SCHEMA", this.stringManager.getString("schema"), (String[])null)};
    }

    public String[] getSchemaList() {
        return null;
    }
}

