/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.hsqldb.gui.seqs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.hsqldb.OrbadaHSqlDbPlugin;
import pl.mpak.orbada.hsqldb.Sql;
import pl.mpak.orbada.hsqldb.cm.CreateSequenceWizardAction;
import pl.mpak.orbada.hsqldb.gui.wizards.AlterSequenceWizardPanel;
import pl.mpak.orbada.hsqldb.services.HSqlDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class SequencesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaHSqlDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonAlterSequence;
    private ToolButton buttonDropTrigger;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmAlterSequence;
    private Action cmDropSequence;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JPopupMenu menuActions;
    private JToolBar.Separator separator;
    private QueryTableStatusBar statusBarSequences;
    private ViewTable tableSequences;
    private JToolBar toolBarTriggers;

    public SequencesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = HSqlDbInfoProvider.getCurrentSchema(this.getDatabase());
        this.toolBarTriggers.add((Component)new ToolButton((javax.swing.Action)((Object)new CreateSequenceWizardAction(this.getDatabase()){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                SequencesPanelView.this.refresh();
            }
        })));
        this.tableSequences.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = SequencesPanelView.this.tableSequences.getSelectedRow();
                if (rowIndex >= 0 && SequencesPanelView.this.tableSequences.getQuery().isActive()) {
                    try {
                        SequencesPanelView.this.tableSequences.getQuery().getRecord(rowIndex);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        });
        this.tableSequences.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("sequence_name", this.stringManager.getString("sequence-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("data_type", this.stringManager.getString("dtd-identifier"), 100));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("maximum_value", this.stringManager.getString("maximum-value"), 70));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("minimum_value", this.stringManager.getString("minimum-value"), 70));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("increment", this.stringManager.getString("increment"), 70));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("cycle_option", this.stringManager.getString("cycle-option"), 40));
            this.tableSequences.addColumn((TableColumn)new QueryTableColumn("start_with", this.stringManager.getString("start-with"), 70));
            SqlFilterDef def = new SqlFilterDef();
            def.add(new SqlFilterDefComponent("sequence_name", this.stringManager.getString("sequence-name"), (String[])null));
            def.add(new SqlFilterDefComponent("data_type", this.stringManager.getString("dtd-identifier"), new String[]{"INTEGER", "BIGINT"}));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-sequences-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, def);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableSequences, (JButton)this.buttonActions, this.menuActions, "hsqldb-sequences-actions");
    }

    public void setCurrentSchemaName(String schemaName) {
        if (!this.currentSchemaName.equals(schemaName)) {
            this.currentSchemaName = schemaName;
            if (!this.currentSchemaName.equalsIgnoreCase(HSqlDbInfoProvider.getCurrentSchema(this.getDatabase()))) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String seqName = null;
            if (this.tableSequences.getQuery().isActive() && this.tableSequences.getSelectedRow() >= 0) {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                seqName = this.tableSequences.getQuery().fieldByName("sequence_name").getString();
            }
            this.refresh(seqName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int index = Math.max(0, this.tableSequences.getSelectedRow());
            this.tableSequences.getQuery().close();
            this.tableSequences.getQuery().setSqlText(Sql.getSequenceList(this.filter.getSqlText(), HSqlDbInfoProvider.getVersionTest(this.getDatabase())));
            this.tableSequences.getQuery().paramByName("schema_name").setString(this.currentSchemaName);
            this.tableSequences.getQuery().open();
            if (objectName != null && this.tableSequences.getQuery().locate("sequence_name", new Variant(objectName))) {
                this.tableSequences.changeSelection(this.tableSequences.getQuery().getCurrentRecord().getIndex(), this.tableSequences.getSelectedColumn());
            } else if (!this.tableSequences.getQuery().isEmpty()) {
                this.tableSequences.changeSelection(Math.min(index, this.tableSequences.getRowCount() - 1), this.tableSequences.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableSequences.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropSequence = new Action();
        this.cmSelectSchema = new Action();
        this.cmAlterSequence = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableSequences = new ViewTable();
        this.statusBarSequences = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonDropTrigger = new ToolButton();
        this.separator = new JToolBar.Separator();
        this.buttonAlterSequence = new ToolButton();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setText(this.stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmFilterActionPerformed(evt);
            }
        });
        this.cmDropSequence.setActionCommandKey("cmDropSequence");
        this.cmDropSequence.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropSequence.setText(this.stringManager.getString("cmDropSequence-text"));
        this.cmDropSequence.setTooltip(this.stringManager.getString("cmDropSequence-hint"));
        this.cmDropSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmDropSequenceActionPerformed(evt);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(this.stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(this.stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmSelectSchemaActionPerformed(evt);
            }
        });
        this.cmAlterSequence.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit_sequence.gif"));
        this.cmAlterSequence.setText(this.stringManager.getString("cmAlterSequence-text"));
        this.cmAlterSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencesPanelView.this.cmAlterSequenceActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                SequencesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableSequences);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarSequences.setShowFieldType(false);
        this.statusBarSequences.setShowOpenTime(false);
        this.statusBarSequences.setTable((QueryTable)this.tableSequences);
        this.jPanel1.add((Component)this.statusBarSequences, "South");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarTriggers.add(this.jSeparator2);
        this.buttonDropTrigger.setAction((javax.swing.Action)this.cmDropSequence);
        this.buttonDropTrigger.setHorizontalTextPosition(0);
        this.buttonDropTrigger.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonDropTrigger);
        this.toolBarTriggers.add(this.separator);
        this.buttonAlterSequence.setAction((javax.swing.Action)this.cmAlterSequence);
        this.buttonAlterSequence.setHorizontalTextPosition(0);
        this.buttonAlterSequence.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonAlterSequence);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmDropSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectionModel().getLeadSelectionIndex());
                String objectName = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableSequences.getQuery().fieldByName("sequence_name").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("SequencesPanelView-drop-sequence-q"), objectName), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop sequence " + objectName, true);
                    this.refresh();
                }
            }
            catch (Exception ex) {
                MessageBox.show((String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent evt) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableSequences.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open(Sql.getSchemaList());
            Vector vl = QueryUtil.staticData((String)"{schema_name}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vl, (int)vl.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object o) {
                    SequencesPanelView.this.setCurrentSchemaName(o.toString());
                    SequencesPanelView.this.refresh();
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    private void cmAlterSequenceActionPerformed(ActionEvent evt) {
        if (this.tableSequences.getSelectedRow() != -1) {
            try {
                this.tableSequences.getQuery().getRecord(this.tableSequences.getSelectedRow());
                if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterSequenceWizardPanel(this.getDatabase(), this.currentSchemaName, this.tableSequences.getQuery().fieldByName("sequence_name").getString()), (boolean)true) != null) {
                    this.refresh();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

